/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.value;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.jmock.Expectations;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.applib.value.TestClock;
import org.nakedobjects.metamodel.adapter.TextEntryParseException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.FacetHolderImpl;
import org.nakedobjects.metamodel.value.JavaUtilDateValueSemanticsProvider;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstract;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstractTestCase;

@RunWith(value=JMock.class)
public class JavaUtilDateValueSemanticsProviderTest
extends ValueSemanticsProviderAbstractTestCase {
    private Date date;
    private FacetHolder holder;

    @Before
    public void setUpObjects() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(JavaUtilDateValueSemanticsProviderTest.this.mockConfiguration)).getString("nakedobjects.value.format.datetime");
                this.will(1.returnValue(null));
            }
        });
        TestClock.initialize();
        this.date = new Date(0L);
        this.holder = new FacetHolderImpl();
        this.setValue((ValueSemanticsProviderAbstract)new JavaUtilDateValueSemanticsProvider(this.holder, this.mockConfiguration, this.mockSpecificationLoader, this.mockRuntimeContext){

            protected String defaultFormat() {
                return "iso";
            }
        });
    }

    @Test
    public void testInvalidParse() throws Exception {
        try {
            this.getValue().parseTextEntry(null, "invalid entry");
            Assert.fail();
        }
        catch (TextEntryParseException textEntryParseException) {
            // empty catch block
        }
    }

    @Test
    public void testTitleOf() {
        String EXPECTED = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date(0L));
        Assert.assertEquals((Object)EXPECTED, (Object)this.getValue().displayTitleOf((Object)this.date));
    }

    @Test
    public void testParse() throws Exception {
        Object newValue = this.getValue().parseTextEntry(null, "1980-01-01 10:40");
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("Etc/UTC"));
        calendar.set(1980, 0, 1, 10, 40, 0);
        calendar.set(14, 0);
        Assert.assertEquals((Object)calendar.getTime(), (Object)newValue);
    }
}

