/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.value;

import org.jmock.Expectations;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.applib.value.Percentage;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.FacetHolderImpl;
import org.nakedobjects.metamodel.value.PercentageValueSemanticsProvider;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstract;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstractTestCase;

@RunWith(value=JMock.class)
public class PercentageValueSemanticsProviderTest
extends ValueSemanticsProviderAbstractTestCase {
    PercentageValueSemanticsProvider adapter;
    private Object percentage;
    private FacetHolder holder;

    @Before
    public void setUpObjects() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(PercentageValueSemanticsProviderTest.this.mockConfiguration)).getString("nakedobjects.value.format.percentage");
                this.will(1.returnValue(null));
            }
        });
        this.setupSpecification(Percentage.class);
        this.percentage = new Percentage(0.105f);
        this.allowMockAdapterToReturn(this.percentage);
        this.holder = new FacetHolderImpl();
        this.adapter = new PercentageValueSemanticsProvider(this.holder, this.mockConfiguration, this.mockSpecificationLoader, this.mockRuntimeContext);
        this.setValue((ValueSemanticsProviderAbstract)this.adapter);
    }

    @Test
    public void testAsEncodedString() {
        String encoded = this.getEncodeableFacet().toEncodedString(this.mockAdapter);
        Assert.assertEquals((Object)"0.105", (Object)encoded);
    }

    @Test
    public void testParseTextEntryWithNumber() {
        Object parsed = this.adapter.parseTextEntry(this.percentage, "21%");
        Assert.assertEquals((Object)new Percentage(0.21f), (Object)parsed);
    }

    @Test
    public void testParseTextEntryWithNumberAndDecimalPoint() {
        Object parsed = this.adapter.parseTextEntry(this.percentage, "21.4%");
        Assert.assertEquals((Object)new Percentage(0.214f), (Object)parsed);
    }

    @Test
    public void testParseTextEntryWithBlank() {
        Object parsed = this.adapter.parseTextEntry(this.percentage, "");
        Assert.assertEquals(null, (Object)parsed);
    }

    @Test
    public void testRestoreFromEncodedString() {
        Object restored = this.adapter.fromEncodedString("0.2134");
        Assert.assertEquals((Object)new Percentage(0.2134f), (Object)restored);
    }

    @Test
    public void testTitleOf() {
        Assert.assertEquals((Object)"10%", (Object)this.adapter.displayTitleOf(this.percentage));
    }

    @Test
    public void testFloatValue() {
        Assert.assertEquals((double)0.105f, (double)this.adapter.floatValue(this.mockAdapter).floatValue(), (double)0.0);
    }
}

