/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.value;

import org.jmock.Expectations;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.applib.value.TestClock;
import org.nakedobjects.applib.value.TimeStamp;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.FacetHolderImpl;
import org.nakedobjects.metamodel.value.TimeStampValueSemanticsProvider;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstract;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstractTestCase;

@RunWith(value=JMock.class)
public class TimeStampValueSemanticsProviderTest
extends ValueSemanticsProviderAbstractTestCase {
    private TimeStampValueSemanticsProvider adapter;
    private Object timestamp;
    private FacetHolder holder;

    @Before
    public void setUpObjects() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(TimeStampValueSemanticsProviderTest.this.mockConfiguration)).getString("nakedobjects.value.format.timestamp");
                this.will(1.returnValue(null));
            }
        });
        TestClock.initialize();
        this.timestamp = new TimeStamp(0L);
        this.holder = new FacetHolderImpl();
        this.adapter = new TimeStampValueSemanticsProvider(this.holder, this.mockConfiguration, this.mockSpecificationLoader, this.mockRuntimeContext);
        this.setValue((ValueSemanticsProviderAbstract)this.adapter);
    }

    public void testParseEmptyString() {
        Object parsed = this.adapter.parseTextEntry(null, "");
        Assert.assertNull((Object)parsed);
    }

    @Test
    public void testTitle() {
        Assert.assertEquals((Object)"01/01/70 00:00:00 UTC", (Object)this.adapter.titleString(this.timestamp));
    }

    @Test
    public void testEncodesTimeStamp() {
        String encodedString = new String(this.adapter.toEncodedString(this.timestamp));
        Assert.assertEquals((Object)"19700101T000000000", (Object)encodedString);
    }

    @Test
    public void testDecodesTimeStamp() {
        String encodedString = "19700101T000000000";
        Object restored = this.adapter.fromEncodedString("19700101T000000000");
        Assert.assertEquals((long)((TimeStamp)this.timestamp).longValue(), (long)((TimeStamp)restored).longValue());
    }
}

