package org.nakedobjects.metamodel.adapter.oid.stringable.hex;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.adapter.oid.stringable.OidStringifier;
import org.nakedobjects.metamodel.commons.encoding.ByteDecoder;
import org.nakedobjects.metamodel.commons.encoding.ByteDecoderBuffer;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoderBuffer;


public class OidStringifierHex implements OidStringifier {

    public String enString(final Oid oid) {
        final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        final ByteEncoder byteEncoder = new ByteEncoderBuffer(baos);
        byteEncoder.add(oid);
        final byte[] byteArray = baos.toByteArray();
        return new String(Hex.encodeHex(byteArray));
    }

    public Oid deString(final String oidStr) {
        final char[] oidCharArray = oidStr.toCharArray();
        byte[] oidBytes;
        try {
            oidBytes = Hex.decodeHex(oidCharArray);
            final ByteArrayInputStream bais = new ByteArrayInputStream(oidBytes);
            final ByteDecoder byteDecoder = new ByteDecoderBuffer(bais);
            return (Oid) byteDecoder.getObject();
        } catch (final DecoderException e) {
            return null;
        }
    }

}
