package org.nakedobjects.metamodel.commons.encoding;

import java.io.InputStream;



public class DebugByteDecoder extends ByteDecoderBuffer {
    private static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(DebugByteDecoder.class);

    public DebugByteDecoder(final InputStream input) {
        super(input);
    }

    @Override
    public boolean getBoolean() {
        final boolean b = super.getBoolean();
        LOG.debug("boolean: " + b);
        return b;
    }

    @Override
    public int getByte() {
        final int b = super.getByte();
        LOG.debug("byte: " + b);
        return b;
    }

    @Override
    public byte[] getBytes() {
        final byte[] bs = super.getBytes();
        LOG.debug("bytes: " + new String(bs));
        return bs;
    }

    @Override
    public int getInt() {
        final int i = super.getInt();
        LOG.debug("int: " + i);
        return i;
    }

    @Override
    public String[] getList() {
        final String[] strings = super.getList();
        LOG.debug("list: " + strings);
        return strings;
    }

    @Override
    public long getLong() {
        final long l = super.getLong();
        LOG.debug("long: " + l);
        return l;
    }

    @Override
    public Object getObject() {
        final Object object = super.getObject();
        LOG.debug(">>> object");
        return object;
    }

    @Override
    public Object[] getObjects() {
        final Object[] objects = super.getObjects();
        LOG.debug(">>> objects x" + objects.length);
        return objects;
    }

    @Override
    public String getString() {
        final String string = super.getString();
        LOG.debug("string: " + string);
        return string;
    }

    @Override
    public void end() {
        LOG.debug("<<<  end");
        super.end();
    }

}

// Copyright (c) Naked Objects Group Ltd.
