package org.nakedobjects.metamodel.commons.encoding;

import java.io.OutputStream;



public class DebugByteEncoder extends ByteEncoderBuffer {
    private static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(DebugByteEncoder.class);

    public DebugByteEncoder(final OutputStream encoder) {
        super(encoder);
    }

    @Override
    public void add(final boolean flag) {
        LOG.debug("boolean: " + flag);
        super.add(flag);
    }

    @Override
    public void add(final byte[] value) {
        LOG.debug("bytes: (" + value.length + ") " + new String(value));
        super.add(value);
    }

    public void add(final byte value) {
        LOG.debug("byte: " + value);
        super.add(value);
    }

    @Override
    public void add(final int value) {
        LOG.debug("int: " + value);
        super.add(value);
    }

    @Override
    public void add(final long value) {
        LOG.debug("long: " + value);
        super.add(value);
    }

    @Override
    public void add(final Object object) {
        LOG.debug(">>> object: (" + object + ")");
        super.add(object);
    }

    @Override
    public void add(final Object[] objects) {
        LOG.debug(">>> objects x" + objects.length);
        super.add(objects);
    }

    @Override
    public void add(final String entry) {
        LOG.debug("string: " + entry);
        super.add(entry);
    }

    @Override
    public void add(final String[] list) {
        final StringBuffer l = new StringBuffer();
        for (int i = 0; i < list.length; i++) {
            if (i > 0) {
                l.append(", ");
            }
            l.append(list[i]);
        }
        LOG.debug("list: " + l);
        super.add(list);
    }

    @Override
    public void end() {
        LOG.debug("<<<  end");
        super.end();
    }
}

// Copyright (c) Naked Objects Group Ltd.
