package org.nakedobjects.metamodel.commons.encoding;

/**
 * This interface indicates that an object can be encoded into into a byte array so it can be streamed.
 * 
 * <p>
 * By implementing this interface you are agreeing to provide a constructor that will create an 
 * instance from a byte array. This constructor must have one parameter and its type must be {@link ByteDecoder}.
 */
public interface Encodable {

    /**
     * Returns the domain object's value as an encoded byte array via the encoder.
     */
    void encode(ByteEncoder encoder);
}

// Copyright (c) Naked Objects Group Ltd.
