package org.nakedobjects.metamodel.config;

import java.awt.Color;
import java.awt.Font;
import java.util.Enumeration;
import java.util.Properties;

import org.nakedobjects.metamodel.commons.debug.DebugString;


public class NakedObjectConfigurationDefault implements NakedObjectConfiguration {

    /**
     * This is a <i>copy</i> of the config passed into the
     * {@link #DefaultNakedObjectConfiguration(NakedObjectConfiguration) constructor}.
     */
    protected NakedObjectConfiguration underlying;

    public NakedObjectConfigurationDefault(final NakedObjectConfiguration original) {
        underlying = original.getProperties("");
    }

    /**
     * Adds a set of properties to the underlying configuration, with the specified prefix.
     * 
     * @param prefix
     * @param properties
     */
    public void addProperties(final String prefix, final Properties properties) {
        final Enumeration e = properties.propertyNames();
        while (e.hasMoreElements()) {
            final String propertyName = (String) e.nextElement();
            final String value = properties.getProperty(propertyName);
            add(prefix + "." + propertyName, value);
        }
    }

    public void add(final String name, final String value) {
        underlying.add(name, value);
    }

    public NakedObjectConfiguration createSubset(final String prefix) {
        return underlying.createSubset(prefix);
    }

    public boolean getBoolean(final String name) {
        return underlying.getBoolean(name);
    }

    public boolean getBoolean(final String name, final boolean defaultValue) {
        return underlying.getBoolean(name, defaultValue);
    }

    public Color getColor(final String name) {
        return underlying.getColor(name);
    }

    public Color getColor(final String name, final Color defaultValue) {
        return underlying.getColor(name, defaultValue);
    }

    public Font getFont(final String name) {
        return underlying.getFont(name);
    }

    public Font getFont(final String name, final Font defaultValue) {
        return underlying.getFont(name, defaultValue);
    }

    public int getInteger(final String name) {
        return underlying.getInteger(name);
    }

    public int getInteger(final String name, final int defaultValue) {
        return underlying.getInteger(name, defaultValue);
    }

    public String[] getList(final String name) {
        return underlying.getList(name);
    }

    public NakedObjectConfiguration getProperties(final String withPrefix) {
        return underlying.getProperties(withPrefix);
    }

    public String getString(final String name) {
        return underlying.getString(name);
    }

    public String getString(final String name, final String defaultValue) {
        return underlying.getString(name, defaultValue);
    }

    public boolean hasProperty(final String name) {
        return underlying.hasProperty(name);
    }

    public boolean isEmpty() {
        return underlying.isEmpty();
    }

    public Enumeration<String> propertyNames() {
        return underlying.propertyNames();
    }

    public String rootPath() {
        return underlying.rootPath();
    }

    public int size() {
        return underlying.size();
    }

    public void debugData(final DebugString debug) {
        underlying.debugData(debug);
    }

    public String debugTitle() {
        return underlying.debugTitle();
    }

    public void injectInto(Object candidate) {
        underlying.injectInto(candidate);
    }

}
