package org.nakedobjects.metamodel.commons.encoding;

import java.io.InputStream;

import org.nakedobjects.metamodel.commons.encoding.ByteDecoder;
import org.nakedobjects.metamodel.commons.encoding.ByteDecoderBuffer;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoderBuffer;
import org.nakedobjects.metamodel.commons.encoding.Encodable;

import junit.framework.TestCase;


public class ByteCoderTest extends TestCase {

    private ByteEncoder encoder;
    private ByteDecoder decoder;

    @Override
    protected void setUp() throws Exception {
        final TestOutputStream out = new TestOutputStream();
        final InputStream in = new TestInputStream(out.data);
        encoder = new ByteEncoderBuffer(out);
        decoder = new ByteDecoderBuffer(in);
    }

    public void testStringEntry() {
        encoder.add("test");
        encoder.add("");
        encoder.add("second");

        assertEquals("test", decoder.getString());
        assertEquals("", decoder.getString());
        assertEquals("second", decoder.getString());
    }

    public void testList() {
        final String[] list = { "one", "two", "three" };
        encoder.add(list);

        final String[] returnedList = decoder.getList();
        assertEquals(list.length, returnedList.length);
        assertEquals(list[0], returnedList[0]);
        assertEquals(list[1], returnedList[1]);
        assertEquals(list[2], returnedList[2]);
    }

    public void testLong() {
        encoder.add(245L);
        encoder.add(-456L);

        assertEquals(245L, decoder.getLong());
        assertEquals(-456L, decoder.getLong());
    }

    public void testBoolean() {
        encoder.add(true);
        encoder.add(false);

        assertEquals(true, decoder.getBoolean());
        assertEquals(false, decoder.getBoolean());
    }

    public void testObject() {
        encoder.add(new EncodableObject());

        final Object object = decoder.getObject();
        assertTrue(object instanceof EncodableObject);
        assertEquals("test field", ((EncodableObject) object).field);
    }

    public void testNull() {
        encoder.add((Object) null);

        final Object object = decoder.getObject();
        assertEquals(null, object);
    }

    public void testObjects() {
        final EncodableObject[] array = new EncodableObject[] { new EncodableObject(), new EncodableObject(),
                new EncodableObject() };
        encoder.add(array);

        final Object[] objects = decoder.getObjects();
        assertTrue(objects instanceof EncodableObject[]);
        assertEquals(3, objects.length);
        assertEquals("test field", ((EncodableObject) objects[2]).field);
    }

    public void testArrayAsObject() {
        final EncodableObject[] array = new EncodableObject[] { new EncodableObject(), new EncodableObject(),
                new EncodableObject() };
        encoder.add((Object) array);

        final Object objects = decoder.getObject();
        assertTrue(objects instanceof EncodableObject[]);
        // assertEquals(3, objects.length);
        // assertEquals("test field", ((EncodableObject) objects[2]).field);
    }
}

class EncodableObject implements Encodable {
    String field;

    public EncodableObject() {}

    public EncodableObject(final ByteDecoder ByteDecoder) {
        field = ByteDecoder.getString();
    }

    public void encode(final ByteEncoder encoder) {
        encoder.add("test field");
    }

}

// Copyright (c) Naked Objects Group Ltd.
