/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.commons.lang;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nakedobjects.metamodel.commons.lang.IoUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IoUtilsCopyTest {
    private static int BUF_INTERNAL_SIZE = 1024;

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test(expected=IllegalArgumentException.class)
    public void handlesNullInputStream() throws Exception {
        InputStream bais = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IoUtils.copy(bais, (OutputStream)baos);
    }

    @Test(expected=IllegalArgumentException.class)
    public void handlesNullOutputStream() throws Exception {
        byte[] bytes = this.createByteArray(10);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        OutputStream baos = null;
        IoUtils.copy((InputStream)bais, baos);
    }

    @Test
    public void copiesEmptyInputStream() throws Exception {
        byte[] bytes = this.createByteArray(0);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IoUtils.copy((InputStream)bais, (OutputStream)baos);
        Assert.assertThat((Object)baos.toByteArray(), this.arrayEqualTo(bytes));
    }

    @Test
    public void copiesInputStreamSmallerThanInternalBuffer() throws Exception {
        byte[] bytes = this.createByteArray(BUF_INTERNAL_SIZE - 1);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IoUtils.copy((InputStream)bais, (OutputStream)baos);
        Assert.assertThat((Object)baos.toByteArray(), this.arrayEqualTo(bytes));
    }

    @Test
    public void copiesInputStreamLargerThanInternalBuffer() throws Exception {
        byte[] bytes = this.createByteArray(BUF_INTERNAL_SIZE + 1);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IoUtils.copy((InputStream)bais, (OutputStream)baos);
        Assert.assertThat((Object)baos.toByteArray(), this.arrayEqualTo(bytes));
    }

    @Test
    public void copiesInputStreamExactlySameSizeAsInternalBuffer() throws Exception {
        byte[] bytes = this.createByteArray(BUF_INTERNAL_SIZE);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IoUtils.copy((InputStream)bais, (OutputStream)baos);
        Assert.assertThat((Object)baos.toByteArray(), this.arrayEqualTo(bytes));
    }

    private Matcher<byte[]> arrayEqualTo(byte[] bytes) {
        return new ArrayMatcher(bytes);
    }

    private byte[] createByteArray(int size) {
        byte[] bytes = new byte[size];
        for (int i = 0; i < size; ++i) {
            bytes[i] = (byte)i;
        }
        return bytes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ArrayMatcher
    extends TypeSafeMatcher<byte[]> {
        private final byte[] expectedBytes;

        public ArrayMatcher(byte[] expectedBytes) {
            this.expectedBytes = expectedBytes;
        }

        public boolean matchesSafely(byte[] actualBytes) {
            if (actualBytes.length != this.expectedBytes.length) {
                return false;
            }
            for (int i = 0; i < actualBytes.length; ++i) {
                if (actualBytes[i] == this.expectedBytes[i]) continue;
                return false;
            }
            return true;
        }

        public void describeTo(Description arg0) {
            arg0.appendText("does not match expected array");
        }
    }
}

