/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.commons.lang;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.nakedobjects.metamodel.commons.names.NameConvertorUtils;

public class NameConvertorTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run(NameConvertorTest.class);
    }

    public void testNaturalNameAddsSpacesToCamelCaseWords() {
        NameConvertorTest.assertEquals((String)"Camel Case Word", (String)NameConvertorUtils.naturalName((String)"CamelCaseWord"));
    }

    public void testNaturalNameAddsSpacesBeforeNumbers() {
        NameConvertorTest.assertEquals((String)"One 2 One", (String)NameConvertorUtils.naturalName((String)"One2One"));
        NameConvertorTest.assertEquals((String)"Type 123", (String)NameConvertorUtils.naturalName((String)"Type123"));
        NameConvertorTest.assertEquals((String)"4321 Go", (String)NameConvertorUtils.naturalName((String)"4321Go"));
    }

    public void testNaturalNameRecognisesAcronymns() {
        NameConvertorTest.assertEquals((String)"TNT Power", (String)NameConvertorUtils.naturalName((String)"TNTPower"));
        NameConvertorTest.assertEquals((String)"Spam RAM Can", (String)NameConvertorUtils.naturalName((String)"SpamRAMCan"));
        NameConvertorTest.assertEquals((String)"DOB", (String)NameConvertorUtils.naturalName((String)"DOB"));
    }

    public void testNaturalNameWithShortNames() {
        NameConvertorTest.assertEquals((String)"At", (String)NameConvertorUtils.naturalName((String)"At"));
        NameConvertorTest.assertEquals((String)"I", (String)NameConvertorUtils.naturalName((String)"I"));
    }

    public void testNaturalNameNoChange() {
        NameConvertorTest.assertEquals((String)"Camel Case Word", (String)NameConvertorUtils.naturalName((String)"CamelCaseWord"));
        NameConvertorTest.assertEquals((String)"Almost Normal english sentence", (String)NameConvertorUtils.naturalName((String)"Almost Normal english sentence"));
    }

    public void testPluralNameAdd_S() {
        NameConvertorTest.assertEquals((String)"Cans", (String)NameConvertorUtils.pluralName((String)"Can"));
        NameConvertorTest.assertEquals((String)"Spaces", (String)NameConvertorUtils.pluralName((String)"Space"));
        NameConvertorTest.assertEquals((String)"Noses", (String)NameConvertorUtils.pluralName((String)"Nose"));
    }

    public void testPluralNameReplace_Y_With_IES() {
        NameConvertorTest.assertEquals((String)"Babies", (String)NameConvertorUtils.pluralName((String)"Baby"));
        NameConvertorTest.assertEquals((String)"Cities", (String)NameConvertorUtils.pluralName((String)"City"));
    }

    public void testPluralNameReplaceAdd_ES() {
        NameConvertorTest.assertEquals((String)"Foxes", (String)NameConvertorUtils.pluralName((String)"Fox"));
        NameConvertorTest.assertEquals((String)"Bosses", (String)NameConvertorUtils.pluralName((String)"Boss"));
    }

    public void testSimpleNameAllToLowerCase() {
        NameConvertorTest.assertEquals((String)"abcde", (String)NameConvertorUtils.simpleName((String)"ABCDE"));
        NameConvertorTest.assertEquals((String)"camelcaseword", (String)NameConvertorUtils.simpleName((String)"CamelCaseWord"));
    }

    public void testSimpleNameNoChanges() {
        NameConvertorTest.assertEquals((String)"nochanges", (String)NameConvertorUtils.simpleName((String)"nochanges"));
    }

    public void testSimpleNameRemoveSpaces() {
        NameConvertorTest.assertEquals((String)"abcde", (String)NameConvertorUtils.simpleName((String)"a bc  de "));
        NameConvertorTest.assertEquals((String)"twoparts", (String)NameConvertorUtils.simpleName((String)"two parts"));
    }
}

