/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.commons.matchers;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nakedobjects.metamodel.commons.matchers.NofMatchers;

public class NofMatcherContainsStripNewLines {
    private Matcher<String> fooMatcher;

    @Before
    public void setUp() {
        this.fooMatcher = NofMatchers.containsStripNewLines((String)"foo");
    }

    @Test
    public void shouldMatchExactString() {
        Assert.assertThat((Object)this.fooMatcher.matches((Object)"foo"), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldMatchIfContainsStringNoNewLines() {
        Assert.assertThat((Object)this.fooMatcher.matches((Object)"abcfoodef"), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldMatchIfContainsStringHasNewLinesBefore() {
        Assert.assertThat((Object)this.fooMatcher.matches((Object)"a\nb\rc\r\ndfoodef"), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldMatchIfContainsStringHasNewLinesAfter() {
        Assert.assertThat((Object)this.fooMatcher.matches((Object)"abrdfood\ne\rfan\rg"), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldMatchIfContainsStringHasNewLinesWithin() {
        Assert.assertThat((Object)this.fooMatcher.matches((Object)"abcf\ro\nodef"), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldNotMatchIfDoesNotContainsString() {
        Assert.assertThat((Object)this.fooMatcher.matches((Object)"fob"), (Matcher)CoreMatchers.is((Object)false));
    }
}

