/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.config.loader;

import junit.framework.TestCase;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.config.loader.ConfigurationLoaderDefault;
import org.nakedobjects.metamodel.config.loader.NotFoundPolicy;

public class DefaultConfigurationLoaderTest
extends TestCase {
    ConfigurationLoaderDefault loader;

    protected void setUp() throws Exception {
        Logger.getRootLogger().setLevel(Level.OFF);
        this.loader = new ConfigurationLoaderDefault("src/test/config");
    }

    public void testDefaultConfiguration() {
        NakedObjectConfiguration configuration = this.loader.load();
        DefaultConfigurationLoaderTest.assertEquals((String)"one", (String)configuration.getString("properties.example"));
    }

    public void testDefaultConfigurationTrailingWhitespace() {
        NakedObjectConfiguration configuration = this.loader.load();
        DefaultConfigurationLoaderTest.assertEquals((String)"in-memory", (String)configuration.getString("properties.trailingWhitespace"));
    }

    public void testAddConfiguration() {
        this.loader.addConfigurationFile("another.properties", NotFoundPolicy.FAIL_FAST);
        NakedObjectConfiguration configuration = this.loader.load();
        DefaultConfigurationLoaderTest.assertEquals((String)"added", (String)configuration.getString("additional.example"));
    }

    public void testAddedConfigurationOveridesEarlierProperties() {
        this.loader.addConfigurationFile("another.properties", NotFoundPolicy.FAIL_FAST);
        NakedObjectConfiguration configuration = this.loader.load();
        DefaultConfigurationLoaderTest.assertEquals((String)"two", (String)configuration.getString("properties.example"));
    }

    public void testAddedConfigurationFailsWhenFileNotFound() {
        try {
            this.loader.addConfigurationFile("unfound.properties", NotFoundPolicy.FAIL_FAST);
            DefaultConfigurationLoaderTest.fail();
        }
        catch (NakedObjectException nakedObjectException) {
            // empty catch block
        }
    }

    public void testAddedConfigurationIgnoreUnfoundFile() {
        this.loader.addConfigurationFile("unfound.properties", NotFoundPolicy.CONTINUE);
    }

    public void testAddProperty() throws Exception {
        this.loader.add("added.property", "added by code");
        NakedObjectConfiguration configuration = this.loader.load();
        DefaultConfigurationLoaderTest.assertEquals((String)"added by code", (String)configuration.getString("added.property"));
    }

    public void testIncludeSystemProperty() throws Exception {
        this.loader.setIncludeSystemProperties(true);
        NakedObjectConfiguration configuration = this.loader.load();
        DefaultConfigurationLoaderTest.assertEquals((String)System.getProperty("os.name"), (String)configuration.getString("os.name"));
    }

    public void testAddConfigurationInDifferentDirectory() throws Exception {
        this.loader.addConfigurationFile("src/test", "three.properties", NotFoundPolicy.FAIL_FAST);
        NakedObjectConfiguration configuration = this.loader.load();
        DefaultConfigurationLoaderTest.assertEquals((String)"version 3", (String)configuration.getString("different.property"));
    }
}

