/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.consent;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nakedobjects.metamodel.consent.InteractionAdvisorFacet;
import org.nakedobjects.metamodel.consent.InteractionResult;

public class InteractionResultTest {
    private InteractionResult result;

    @Before
    public void setUp() throws Exception {
        this.result = new InteractionResult(null);
    }

    @After
    public void tearDown() throws Exception {
        this.result = null;
    }

    @Test
    public void shouldHaveNullReasonWhenJustInstantiated() {
        Assert.assertEquals(null, (Object)this.result.getReason());
    }

    @Test
    public void shouldBeEmptyWhenJustInstantiated() {
        Assert.assertFalse((boolean)this.result.isVetoing());
        Assert.assertTrue((boolean)this.result.isNotVetoing());
    }

    @Test
    public void shouldHaveNonNullReasonWhenAdvisedWithNonNull() {
        this.result.advise("foo", InteractionAdvisorFacet.NOOP);
        Assert.assertEquals((Object)"foo", (Object)this.result.getReason());
    }

    @Test
    public void shouldConcatenateAdviseWhenAdvisedWithNonNull() {
        this.result.advise("foo", InteractionAdvisorFacet.NOOP);
        this.result.advise("bar", InteractionAdvisorFacet.NOOP);
        Assert.assertEquals((Object)"foo; bar", (Object)this.result.getReason());
    }

    @Test
    public void shouldNotBeEmptyWhenAdvisedWithNonNull() {
        this.result.advise("foo", InteractionAdvisorFacet.NOOP);
        Assert.assertTrue((boolean)this.result.isVetoing());
        Assert.assertFalse((boolean)this.result.isNotVetoing());
    }

    @Test
    public void shouldBeEmptyWhenAdvisedWithNull() {
        this.result.advise(null, InteractionAdvisorFacet.NOOP);
        Assert.assertTrue((boolean)this.result.isNotVetoing());
        Assert.assertFalse((boolean)this.result.isVetoing());
        Assert.assertEquals(null, (Object)this.result.getReason());
    }
}

