/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets;

import junit.framework.TestCase;
import org.nakedobjects.metamodel.facets.EnumerationAbstract;

public class EnumerationAbstractTest
extends TestCase {
    private EnumerationAbstract foo1;
    private EnumerationAbstract foo2;
    private EnumerationAbstract bar1;
    private EnumerationAbstract fooInterloper;

    protected void setUp() throws Exception {
        super.setUp();
        this.foo1 = new ConcreteEnumeration(1, "foo", "Foo");
        this.foo2 = new ConcreteEnumeration(1, "foo", "Foo");
        this.bar1 = new ConcreteEnumeration(2, "bar", "Bar");
        this.fooInterloper = new OtherConcreteEnumeration(1, "foo", "Foo");
    }

    protected void tearDown() throws Exception {
        this.bar1 = null;
        this.foo2 = null;
        this.foo1 = null;
        super.tearDown();
    }

    public void testGetNum() {
        EnumerationAbstractTest.assertEquals((int)1, (int)this.foo1.getNum());
    }

    public void testGetNameInCode() {
        EnumerationAbstractTest.assertEquals((String)"foo", (String)this.foo1.getNameInCode());
    }

    public void testGetFriendlyName() {
        EnumerationAbstractTest.assertEquals((String)"Foo", (String)this.foo1.getFriendlyName());
    }

    public void testEqualsAbstractEnumerationForSelf() {
        EnumerationAbstractTest.assertTrue((boolean)this.foo1.equals((Object)this.foo1));
    }

    public void testEqualsAbstractEnumerationForEqual() {
        EnumerationAbstractTest.assertTrue((boolean)this.foo1.equals((Object)this.foo2));
    }

    public void testEqualsAbstractEnumerationForDifferent() {
        EnumerationAbstractTest.assertFalse((boolean)this.foo1.equals((Object)this.bar1));
    }

    public void testEqualsAbstractEnumerationForSameCardinalButDifferentType() {
        EnumerationAbstractTest.assertFalse((boolean)this.foo1.equals((Object)this.fooInterloper));
    }

    public void testHashCodeForEqual() {
        EnumerationAbstractTest.assertEquals((int)this.foo1.hashCode(), (int)this.foo2.hashCode());
    }

    public void testHashCodeForDifferent() {
        EnumerationAbstractTest.assertFalse((this.foo1.hashCode() == this.bar1.hashCode() ? 1 : 0) != 0);
    }

    public class OtherConcreteEnumeration
    extends EnumerationAbstract {
        protected OtherConcreteEnumeration(int num, String nameInCode, String friendlyName) {
            super(num, nameInCode, friendlyName);
        }
    }

    public class ConcreteEnumeration
    extends EnumerationAbstract {
        protected ConcreteEnumeration(int num, String nameInCode, String friendlyName) {
            super(num, nameInCode, friendlyName);
        }
    }
}

