/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets;

import junit.framework.TestCase;
import org.nakedobjects.metamodel.commons.filters.Filter;
import org.nakedobjects.metamodel.commons.filters.Filters;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetAbstract;
import org.nakedobjects.metamodel.facets.FacetFilters;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.FacetHolderImpl;

public class FacetFiltersTest
extends TestCase {
    private FacetHolder facetHolder;
    private FooFacet fooFacet;
    private FooSubFacet fooSubFacet;
    private FooSuperFacet fooSuperFacet;
    private BarFacet barFacet;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetHolder = new FacetHolderImpl();
        this.fooSuperFacet = new FooSuperFacet(FooSuperFacet.class, this.facetHolder);
        this.fooFacet = new FooFacet(this.facetHolder);
        this.fooSubFacet = new FooSubFacet(this.facetHolder);
        this.barFacet = new BarFacet(this.facetHolder);
    }

    protected void tearDown() throws Exception {
        this.facetHolder = null;
        this.fooSuperFacet = null;
        this.fooSubFacet = null;
        this.fooFacet = null;
        this.barFacet = null;
        super.tearDown();
    }

    public void testIsAWhenIs() {
        Filter filter = FacetFilters.isA(FooFacet.class);
        FacetFiltersTest.assertTrue((boolean)filter.accept((Object)this.fooFacet));
    }

    public void testIsAWhenIsNot() {
        Filter filter = FacetFilters.isA(FooFacet.class);
        FacetFiltersTest.assertFalse((boolean)filter.accept((Object)this.barFacet));
    }

    public void testIsAWhenIsSubclass() {
        Filter filter = FacetFilters.isA(FooFacet.class);
        FacetFiltersTest.assertTrue((boolean)filter.accept((Object)this.fooSubFacet));
    }

    public void testIsAWhenIsNotBecauseASuperclass() {
        Filter filter = FacetFilters.isA(FooFacet.class);
        FacetFiltersTest.assertFalse((boolean)filter.accept((Object)this.fooSuperFacet));
    }

    public void testAndTrueTrue() {
        Filter and = Filters.and((Filter)FacetFilters.ANY, (Filter)FacetFilters.ANY);
        FacetFiltersTest.assertTrue((boolean)and.accept((Object)this.fooFacet));
    }

    public void testAndTrueFalse() {
        Filter and = Filters.and((Filter)FacetFilters.ANY, (Filter)FacetFilters.NONE);
        FacetFiltersTest.assertFalse((boolean)and.accept((Object)this.fooFacet));
    }

    public void testAndFalseTrue() {
        Filter and = Filters.and((Filter)FacetFilters.NONE, (Filter)FacetFilters.ANY);
        FacetFiltersTest.assertFalse((boolean)and.accept((Object)this.fooFacet));
    }

    public void testAndFalseFalse() {
        Filter and = Filters.and((Filter)FacetFilters.NONE, (Filter)FacetFilters.NONE);
        FacetFiltersTest.assertFalse((boolean)and.accept((Object)this.fooFacet));
    }

    public void testOrTrueTrue() {
        Filter or = Filters.or((Filter)FacetFilters.ANY, (Filter)FacetFilters.ANY);
        FacetFiltersTest.assertTrue((boolean)or.accept((Object)this.fooFacet));
    }

    public void testOrTrueFalse() {
        Filter or = Filters.or((Filter)FacetFilters.ANY, (Filter)FacetFilters.NONE);
        FacetFiltersTest.assertTrue((boolean)or.accept((Object)this.fooFacet));
    }

    public void testorFalseTrue() {
        Filter or = Filters.or((Filter)FacetFilters.NONE, (Filter)FacetFilters.ANY);
        FacetFiltersTest.assertTrue((boolean)or.accept((Object)this.fooFacet));
    }

    public void testOrFalseFalse() {
        Filter or = Filters.and((Filter)FacetFilters.NONE, (Filter)FacetFilters.NONE);
        FacetFiltersTest.assertFalse((boolean)or.accept((Object)this.fooFacet));
    }

    public void testNotTrue() {
        Filter not = Filters.not((Filter)FacetFilters.ANY);
        FacetFiltersTest.assertFalse((boolean)not.accept((Object)this.fooFacet));
    }

    public void testNotFalse() {
        Filter not = Filters.not((Filter)FacetFilters.NONE);
        FacetFiltersTest.assertTrue((boolean)not.accept((Object)this.fooFacet));
    }

    public void testAny() {
        Filter any = Filters.any();
        FacetFiltersTest.assertTrue((boolean)any.accept((Object)this.fooFacet));
    }

    public void testNone() {
        Filter none = Filters.none();
        FacetFiltersTest.assertFalse((boolean)none.accept((Object)this.fooFacet));
    }

    public class BarFacet
    extends FacetAbstract {
        public BarFacet(FacetHolder holder) {
            super(BarFacet.class, holder, false);
        }
    }

    public class FooSubFacet
    extends FooFacet {
        public FooSubFacet(FacetHolder holder) {
            super(holder);
        }
    }

    public class FooFacet
    extends FooSuperFacet {
        public FooFacet(FacetHolder holder) {
            super(FooFacet.class, holder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FooSuperFacet
    extends FacetAbstract {
        public FooSuperFacet(Class<? extends Facet> facetType, FacetHolder holder) {
            super(facetType, holder, false);
        }
    }
}

