/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.actcoll.typeof;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.nakedobjects.applib.annotation.TypeOf;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.actcoll.typeof.TypeOfAnnotationFacetFactory;
import org.nakedobjects.metamodel.facets.actcoll.typeof.TypeOfAnnotationFacetFactoryTest;
import org.nakedobjects.metamodel.facets.actcoll.typeof.TypeOfFacet;
import org.nakedobjects.metamodel.facets.actcoll.typeof.TypeOfFacetInferredFromArray;
import org.nakedobjects.metamodel.facets.actcoll.typeof.TypeOfFacetInferredFromGenerics;
import org.nakedobjects.metamodel.facets.actcoll.typeof.TypeOfFacetViaAnnotation;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;
import org.nakedobjects.metamodel.specloader.collectiontyperegistry.CollectionTypeRegistry;
import org.nakedobjects.metamodel.specloader.collectiontyperegistry.CollectionTypeRegistryDefault;

public class TypeOfAnnotationFacetFactoryTest
extends AbstractFacetFactoryTest {
    private TypeOfAnnotationFacetFactory facetFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new TypeOfAnnotationFacetFactory();
        this.facetFactory.setCollectionTypeRegistry((CollectionTypeRegistry)new CollectionTypeRegistryDefault());
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        TypeOfAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        TypeOfAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        TypeOfAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        TypeOfAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        TypeOfAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testTypeOfFacetInferredForActionWithJavaUtilCollectionReturnType() {
        class Customer {
            Customer() {
            }

            @TypeOf(value=Order.class)
            public Collection someAction() {
                return null;
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction");
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(TypeOfFacet.class);
        TypeOfAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        TypeOfAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof TypeOfFacetViaAnnotation));
        TypeOfFacetViaAnnotation typeOfFacetViaAnnotation = (TypeOfFacetViaAnnotation)facet;
        class Order {
            Order() {
            }
        }
        TypeOfAnnotationFacetFactoryTest.assertEquals(Order.class, (Object)typeOfFacetViaAnnotation.value());
        this.assertNoMethodsRemoved();
    }

    public void testTypeOfFacetInferredForCollectionWithJavaUtilCollectionReturnType() {
        class Customer {
            Customer() {
            }

            @TypeOf(value=Order.class)
            public Collection getOrders() {
                return null;
            }
        }
        Method accessorMethod = this.findMethod(Customer.class, "getOrders");
        this.facetFactory.process(accessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(TypeOfFacet.class);
        TypeOfAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        TypeOfAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof TypeOfFacetViaAnnotation));
        TypeOfFacetViaAnnotation typeOfFacetViaAnnotation = (TypeOfFacetViaAnnotation)facet;
        class Order {
            Order() {
            }
        }
        TypeOfAnnotationFacetFactoryTest.assertEquals(Order.class, (Object)typeOfFacetViaAnnotation.value());
        this.assertNoMethodsRemoved();
    }

    public void testTypeOfFacetInferredForActionWithGenericCollectionReturnType() {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Customer {
            Customer() {
            }

            public Collection<Order> someAction() {
                return null;
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction");
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(TypeOfFacet.class);
        TypeOfAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        TypeOfAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof TypeOfFacetInferredFromGenerics));
        TypeOfFacetInferredFromGenerics typeOfFacetInferredFromGenerics = (TypeOfFacetInferredFromGenerics)facet;
        class Order {
            Order() {
            }
        }
        TypeOfAnnotationFacetFactoryTest.assertEquals(Order.class, (Object)typeOfFacetInferredFromGenerics.value());
    }

    public void testTypeOfFacetInferredForCollectionWithGenericCollectionReturnType() {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Customer {
            Customer() {
            }

            public Collection<Order> getOrders() {
                return null;
            }
        }
        Method collectionAccessorMethod = this.findMethod(Customer.class, "getOrders");
        this.facetFactory.process(collectionAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(TypeOfFacet.class);
        TypeOfAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        TypeOfAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof TypeOfFacetInferredFromGenerics));
        TypeOfFacetInferredFromGenerics typeOfFacetInferredFromGenerics = (TypeOfFacetInferredFromGenerics)facet;
        class Order {
            Order() {
            }
        }
        TypeOfAnnotationFacetFactoryTest.assertEquals(Order.class, (Object)typeOfFacetInferredFromGenerics.value());
    }

    public void testTypeOfFacetInferredForActionWithJavaUtilListReturnType() {
        class Customer {
            Customer() {
            }

            @TypeOf(value=Order.class)
            public List someAction() {
                return null;
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction");
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(TypeOfFacet.class);
        TypeOfAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        TypeOfAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof TypeOfFacetViaAnnotation));
        TypeOfFacetViaAnnotation typeOfFacetViaAnnotation = (TypeOfFacetViaAnnotation)facet;
        class Order {
            Order() {
            }
        }
        TypeOfAnnotationFacetFactoryTest.assertEquals(Order.class, (Object)typeOfFacetViaAnnotation.value());
        this.assertNoMethodsRemoved();
    }

    public void testTypeOfFacetInferredForCollectionWithJavaUtilListReturnType() {
        class Customer {
            Customer() {
            }

            @TypeOf(value=Order.class)
            public List getOrders() {
                return null;
            }
        }
        Method accessorMethod = this.findMethod(Customer.class, "getOrders");
        this.facetFactory.process(accessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(TypeOfFacet.class);
        TypeOfAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        TypeOfAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof TypeOfFacetViaAnnotation));
        TypeOfFacetViaAnnotation typeOfFacetViaAnnotation = (TypeOfFacetViaAnnotation)facet;
        class Order {
            Order() {
            }
        }
        TypeOfAnnotationFacetFactoryTest.assertEquals(Order.class, (Object)typeOfFacetViaAnnotation.value());
        this.assertNoMethodsRemoved();
    }

    public void testTypeOfFacetInferredForActionWithJavaUtilSetReturnType() {
        class Customer {
            Customer() {
            }

            @TypeOf(value=Order.class)
            public Set someAction() {
                return null;
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction");
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(TypeOfFacet.class);
        TypeOfAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        TypeOfAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof TypeOfFacetViaAnnotation));
        TypeOfFacetViaAnnotation typeOfFacetViaAnnotation = (TypeOfFacetViaAnnotation)facet;
        class Order {
            Order() {
            }
        }
        TypeOfAnnotationFacetFactoryTest.assertEquals(Order.class, (Object)typeOfFacetViaAnnotation.value());
        this.assertNoMethodsRemoved();
    }

    public void testTypeOfFacetInferredForCollectionWithJavaUtilSetReturnType() {
        class Customer {
            Customer() {
            }

            @TypeOf(value=Order.class)
            public Set getOrders() {
                return null;
            }
        }
        Method accessorMethod = this.findMethod(Customer.class, "getOrders");
        this.facetFactory.process(accessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(TypeOfFacet.class);
        TypeOfAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        TypeOfAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof TypeOfFacetViaAnnotation));
        TypeOfFacetViaAnnotation typeOfFacetViaAnnotation = (TypeOfFacetViaAnnotation)facet;
        class Order {
            Order() {
            }
        }
        TypeOfAnnotationFacetFactoryTest.assertEquals(Order.class, (Object)typeOfFacetViaAnnotation.value());
        this.assertNoMethodsRemoved();
    }

    public void testTypeOfFacetInferredForActionWithArrayReturnType() {
        class Customer {
            Customer() {
            }

            public Order[] someAction() {
                return null;
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction");
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(TypeOfFacet.class);
        TypeOfAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        TypeOfAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof TypeOfFacetInferredFromArray));
        TypeOfFacetInferredFromArray typeOfFacetInferredFromArray = (TypeOfFacetInferredFromArray)facet;
        class Order {
            Order() {
            }
        }
        TypeOfAnnotationFacetFactoryTest.assertEquals(Order.class, (Object)typeOfFacetInferredFromArray.value());
        this.assertNoMethodsRemoved();
    }

    public void testTypeOfFacetIsInferredForCollectionFromOrderArray() {
        class Customer {
            Customer() {
            }

            public Order[] getOrders() {
                return null;
            }
        }
        Method collectionAccessorMethod = this.findMethod(Customer.class, "getOrders");
        this.facetFactory.process(collectionAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(TypeOfFacet.class);
        TypeOfAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        TypeOfAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof TypeOfFacetInferredFromArray));
        TypeOfFacetInferredFromArray typeOfFacetInferredFromArray = (TypeOfFacetInferredFromArray)facet;
        class Order {
            Order() {
            }
        }
        TypeOfAnnotationFacetFactoryTest.assertEquals(Order.class, (Object)typeOfFacetInferredFromArray.value());
    }

    public void testTypeOfAnnotationIgnoredForActionIfReturnTypeIsntACollectionType() {
        class Customer {
            Customer() {
            }

            @TypeOf(value=11Order.class)
            public Customer someAction() {
                return null;
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction");
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        TypeOfAnnotationFacetFactoryTest.assertNull((Object)this.facetHolder.getFacet(TypeOfFacet.class));
        this.assertNoMethodsRemoved();
    }
}

