/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.naming.describedas;

import java.lang.reflect.Method;
import java.util.Collection;
import org.nakedobjects.applib.annotation.DescribedAs;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.naming.describedas.DescribedAsAnnotationFacetFactory;
import org.nakedobjects.metamodel.facets.naming.describedas.DescribedAsFacet;
import org.nakedobjects.metamodel.facets.naming.describedas.DescribedAsFacetAbstract;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class DescribedAsAnnotationFacetFactoryTest
extends AbstractFacetFactoryTest {
    private DescribedAsAnnotationFacetFactory facetFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new DescribedAsAnnotationFacetFactory();
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        DescribedAsAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        DescribedAsAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        DescribedAsAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        DescribedAsAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        DescribedAsAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testDescribedAsAnnotationPickedUpOnClass() {
        @DescribedAs(value="some description")
        class Customer {
            Customer() {
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction");
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(DescribedAsFacet.class);
        DescribedAsAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        DescribedAsAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof DescribedAsFacetAbstract));
        DescribedAsFacetAbstract describedAsFacetAbstract = (DescribedAsFacetAbstract)facet;
        DescribedAsAnnotationFacetFactoryTest.assertEquals((String)"some description", (String)describedAsFacetAbstract.value());
        this.assertNoMethodsRemoved();
    }

    public void testDescribedAsAnnotationPickedUpOnProperty() {
        class Customer {
            Customer() {
            }

            @DescribedAs(value="some description")
            public int getNumberOfOrders() {
                return 0;
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "getNumberOfOrders");
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(DescribedAsFacet.class);
        DescribedAsAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        DescribedAsAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof DescribedAsFacetAbstract));
        DescribedAsFacetAbstract describedAsFacetAbstract = (DescribedAsFacetAbstract)facet;
        DescribedAsAnnotationFacetFactoryTest.assertEquals((String)"some description", (String)describedAsFacetAbstract.value());
        this.assertNoMethodsRemoved();
    }

    public void testDescribedAsAnnotationPickedUpOnCollection() {
        class Customer {
            Customer() {
            }

            @DescribedAs(value="some description")
            public Collection getOrders() {
                return null;
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "getOrders");
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(DescribedAsFacet.class);
        DescribedAsAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        DescribedAsAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof DescribedAsFacetAbstract));
        DescribedAsFacetAbstract describedAsFacetAbstract = (DescribedAsFacetAbstract)facet;
        DescribedAsAnnotationFacetFactoryTest.assertEquals((String)"some description", (String)describedAsFacetAbstract.value());
        this.assertNoMethodsRemoved();
    }

    public void testDescribedAsAnnotationPickedUpOnAction() {
        class Customer {
            Customer() {
            }

            @DescribedAs(value="some description")
            public void someAction() {
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction");
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(DescribedAsFacet.class);
        DescribedAsAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        DescribedAsAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof DescribedAsFacetAbstract));
        DescribedAsFacetAbstract describedAsFacetAbstract = (DescribedAsFacetAbstract)facet;
        DescribedAsAnnotationFacetFactoryTest.assertEquals((String)"some description", (String)describedAsFacetAbstract.value());
        this.assertNoMethodsRemoved();
    }

    public void testDescribedAsAnnotationPickedUpOnActionParameter() {
        class Customer {
            Customer() {
            }

            public void someAction(@DescribedAs(value="some description") int x) {
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction", new Class[]{Integer.TYPE});
        this.facetFactory.processParams(actionMethod, 0, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(DescribedAsFacet.class);
        DescribedAsAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        DescribedAsAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof DescribedAsFacetAbstract));
        DescribedAsFacetAbstract describedAsFacetAbstract = (DescribedAsFacetAbstract)facet;
        DescribedAsAnnotationFacetFactoryTest.assertEquals((String)"some description", (String)describedAsFacetAbstract.value());
    }
}

