/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.object.defaults;

import org.nakedobjects.applib.adapters.DefaultsProvider;
import org.nakedobjects.applib.annotation.Defaulted;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.config.prop.PropertiesConfiguration;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.object.defaults.DefaultedAnnotationFacetFactory;
import org.nakedobjects.metamodel.facets.object.defaults.DefaultedFacet;
import org.nakedobjects.metamodel.facets.object.defaults.DefaultedFacetAbstract;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class DefaultedFacetFactoryTest
extends AbstractFacetFactoryTest {
    private DefaultedAnnotationFacetFactory facetFactory;
    private PropertiesConfiguration propertiesConfiguration;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new DefaultedAnnotationFacetFactory();
        this.propertiesConfiguration = new PropertiesConfiguration();
        this.facetFactory.setNakedObjectConfiguration((NakedObjectConfiguration)this.propertiesConfiguration);
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        DefaultedFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        DefaultedFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        DefaultedFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        DefaultedFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        DefaultedFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testFacetPickedUp() {
        this.facetFactory.process(MyDefaultedUsingDefaultsProvider.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        DefaultedFacet facet = (DefaultedFacet)this.facetHolder.getFacet(DefaultedFacet.class);
        DefaultedFacetFactoryTest.assertNotNull((Object)facet);
        DefaultedFacetFactoryTest.assertTrue((boolean)(facet instanceof DefaultedFacetAbstract));
    }

    public void testFacetFacetHolderStored() {
        this.facetFactory.process(MyDefaultedUsingDefaultsProvider.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        DefaultedFacetAbstract valueFacet = (DefaultedFacetAbstract)this.facetHolder.getFacet(DefaultedFacet.class);
        DefaultedFacetFactoryTest.assertEquals((Object)this.facetHolder, (Object)valueFacet.getFacetHolder());
    }

    public void testNoMethodsRemoved() {
        this.facetFactory.process(MyDefaultedUsingDefaultsProvider.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        this.assertNoMethodsRemoved();
    }

    public void testDefaultedUsingDefaultsProviderName() {
        this.facetFactory.process(MyDefaultedUsingDefaultsProvider.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        DefaultedFacetAbstract facet = (DefaultedFacetAbstract)this.facetHolder.getFacet(DefaultedFacet.class);
        DefaultedFacetFactoryTest.assertEquals(MyDefaultedUsingDefaultsProvider.class, (Object)facet.getDefaultsProviderClass());
    }

    public void testDefaultedUsingDefaultsProviderClass() {
        this.facetFactory.process(MyDefaultedUsingDefaultsProviderClass.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        DefaultedFacetAbstract facet = (DefaultedFacetAbstract)this.facetHolder.getFacet(DefaultedFacet.class);
        DefaultedFacetFactoryTest.assertEquals(MyDefaultedUsingDefaultsProviderClass.class, (Object)facet.getDefaultsProviderClass());
    }

    public void testDefaultedMustBeADefaultsProvider() {
    }

    public void testDefaultedMustHaveANoArgConstructor() {
        this.facetFactory.process(MyDefaultedWithoutNoArgConstructor.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        DefaultedFacetAbstract facet = (DefaultedFacetAbstract)this.facetHolder.getFacet(DefaultedFacet.class);
        DefaultedFacetFactoryTest.assertNull((Object)facet);
    }

    public void testDefaultedHaveAPublicNoArgConstructor() {
        this.facetFactory.process(MyDefaultedWithoutPublicNoArgConstructor.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        DefaultedFacetAbstract facet = (DefaultedFacetAbstract)this.facetHolder.getFacet(DefaultedFacet.class);
        DefaultedFacetFactoryTest.assertNull((Object)facet);
    }

    public void testDefaultedProviderNameCanBePickedUpFromConfiguration() {
        String className = "org.nakedobjects.metamodel.facets.object.defaults.DefaultedFacetFactoryTest$MyDefaultedWithDefaultsProviderSpecifiedUsingConfiguration";
        this.propertiesConfiguration.add("nakedobjects.reflector.java.facets.defaulted." + this.canonical("org.nakedobjects.metamodel.facets.object.defaults.DefaultedFacetFactoryTest$MyDefaultedWithDefaultsProviderSpecifiedUsingConfiguration") + ".providerName", "org.nakedobjects.metamodel.facets.object.defaults.DefaultedFacetFactoryTest$MyDefaultedWithDefaultsProviderSpecifiedUsingConfiguration");
        this.facetFactory.process(MyDefaultedWithDefaultsProviderSpecifiedUsingConfiguration.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        DefaultedFacetAbstract facet = (DefaultedFacetAbstract)this.facetHolder.getFacet(DefaultedFacet.class);
        DefaultedFacetFactoryTest.assertNotNull((Object)facet);
        DefaultedFacetFactoryTest.assertEquals(MyDefaultedWithDefaultsProviderSpecifiedUsingConfiguration.class, (Object)facet.getDefaultsProviderClass());
    }

    public void testNonAnnotatedDefaultedCanBePickedUpFromConfiguration() {
        String className = "org.nakedobjects.metamodel.facets.object.defaults.DefaultedFacetFactoryTest$NonAnnotatedDefaultedDefaultsProviderSpecifiedUsingConfiguration";
        this.propertiesConfiguration.add("nakedobjects.reflector.java.facets.defaulted." + this.canonical("org.nakedobjects.metamodel.facets.object.defaults.DefaultedFacetFactoryTest$NonAnnotatedDefaultedDefaultsProviderSpecifiedUsingConfiguration") + ".providerName", "org.nakedobjects.metamodel.facets.object.defaults.DefaultedFacetFactoryTest$NonAnnotatedDefaultedDefaultsProviderSpecifiedUsingConfiguration");
        this.facetFactory.process(NonAnnotatedDefaultedDefaultsProviderSpecifiedUsingConfiguration.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        DefaultedFacetAbstract facet = (DefaultedFacetAbstract)this.facetHolder.getFacet(DefaultedFacet.class);
        DefaultedFacetFactoryTest.assertNotNull((Object)facet);
        DefaultedFacetFactoryTest.assertEquals(NonAnnotatedDefaultedDefaultsProviderSpecifiedUsingConfiguration.class, (Object)facet.getDefaultsProviderClass());
    }

    private String canonical(String className) {
        return className.replace('$', '.');
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NonAnnotatedDefaultedDefaultsProviderSpecifiedUsingConfiguration
    extends DefaultsProviderNoop<NonAnnotatedDefaultedDefaultsProviderSpecifiedUsingConfiguration> {
        @Override
        public NonAnnotatedDefaultedDefaultsProviderSpecifiedUsingConfiguration getDefaultValue() {
            return new NonAnnotatedDefaultedDefaultsProviderSpecifiedUsingConfiguration();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Defaulted
    public static class MyDefaultedWithDefaultsProviderSpecifiedUsingConfiguration
    extends DefaultsProviderNoop<MyDefaultedWithDefaultsProviderSpecifiedUsingConfiguration> {
        @Override
        public MyDefaultedWithDefaultsProviderSpecifiedUsingConfiguration getDefaultValue() {
            return new MyDefaultedWithDefaultsProviderSpecifiedUsingConfiguration();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Defaulted(defaultsProviderClass=MyDefaultedWithoutPublicNoArgConstructor.class)
    public static class MyDefaultedWithoutPublicNoArgConstructor
    extends DefaultsProviderNoop<MyDefaultedWithoutPublicNoArgConstructor> {
        MyDefaultedWithoutPublicNoArgConstructor() {
        }

        public MyDefaultedWithoutPublicNoArgConstructor(int value) {
        }

        @Override
        public MyDefaultedWithoutPublicNoArgConstructor getDefaultValue() {
            return new MyDefaultedWithoutPublicNoArgConstructor();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Defaulted(defaultsProviderClass=MyDefaultedWithoutNoArgConstructor.class)
    public static class MyDefaultedWithoutNoArgConstructor
    extends DefaultsProviderNoop<MyDefaultedWithoutNoArgConstructor> {
        public MyDefaultedWithoutNoArgConstructor(int value) {
        }

        @Override
        public MyDefaultedWithoutNoArgConstructor getDefaultValue() {
            return new MyDefaultedWithoutNoArgConstructor(0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Defaulted(defaultsProviderClass=MyDefaultedUsingDefaultsProviderClass.class)
    public static class MyDefaultedUsingDefaultsProviderClass
    extends DefaultsProviderNoop<MyDefaultedUsingDefaultsProviderClass> {
        @Override
        public MyDefaultedUsingDefaultsProviderClass getDefaultValue() {
            return new MyDefaultedUsingDefaultsProviderClass();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Defaulted(defaultsProviderName="org.nakedobjects.metamodel.facets.object.defaults.DefaultedFacetFactoryTest$MyDefaultedUsingDefaultsProvider")
    public static class MyDefaultedUsingDefaultsProvider
    extends DefaultsProviderNoop<MyDefaultedUsingDefaultsProvider> {
        @Override
        public MyDefaultedUsingDefaultsProvider getDefaultValue() {
            return new MyDefaultedUsingDefaultsProvider();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class DefaultsProviderNoop<T>
    implements DefaultsProvider<T> {
        DefaultsProviderNoop() {
        }

        public abstract T getDefaultValue();
    }
}

