/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.object.immutable;

import org.nakedobjects.applib.annotation.Immutable;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.When;
import org.nakedobjects.metamodel.facets.object.immutable.ImmutableAnnotationFacetFactory;
import org.nakedobjects.metamodel.facets.object.immutable.ImmutableFacet;
import org.nakedobjects.metamodel.facets.object.immutable.ImmutableFacetAnnotation;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class ImmutableAnnotationFacetFactoryTest
extends AbstractFacetFactoryTest {
    private ImmutableAnnotationFacetFactory facetFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new ImmutableAnnotationFacetFactory();
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        ImmutableAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        ImmutableAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        ImmutableAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        ImmutableAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        ImmutableAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testImmutableAnnotationPickedUpOnClassAndDefaultsToAlways() {
        @Immutable
        class Customer {
            Customer() {
            }
        }
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(ImmutableFacet.class);
        ImmutableAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        ImmutableAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof ImmutableFacetAnnotation));
        ImmutableFacetAnnotation immutableFacetAnnotation = (ImmutableFacetAnnotation)facet;
        ImmutableAnnotationFacetFactoryTest.assertEquals((Object)When.ALWAYS, (Object)immutableFacetAnnotation.value());
        this.assertNoMethodsRemoved();
    }

    public void testImmutableAnnotationAlwaysPickedUpOnClass() {
        @Immutable(value=org.nakedobjects.applib.annotation.When.ALWAYS)
        class Customer {
            Customer() {
            }
        }
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(ImmutableFacet.class);
        ImmutableAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        ImmutableAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof ImmutableFacetAnnotation));
        ImmutableFacetAnnotation immutableFacetAnnotation = (ImmutableFacetAnnotation)facet;
        ImmutableAnnotationFacetFactoryTest.assertEquals((Object)When.ALWAYS, (Object)immutableFacetAnnotation.value());
        this.assertNoMethodsRemoved();
    }

    public void testImmutableAnnotationNeverPickedUpOnClass() {
        @Immutable(value=org.nakedobjects.applib.annotation.When.NEVER)
        class Customer {
            Customer() {
            }
        }
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(ImmutableFacet.class);
        ImmutableAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        ImmutableAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof ImmutableFacetAnnotation));
        ImmutableFacetAnnotation immutableFacetAnnotation = (ImmutableFacetAnnotation)facet;
        ImmutableAnnotationFacetFactoryTest.assertEquals((Object)When.NEVER, (Object)immutableFacetAnnotation.value());
        this.assertNoMethodsRemoved();
    }

    public void testImmutableAnnotationOncePersistedPickedUpOnClass() {
        @Immutable(value=org.nakedobjects.applib.annotation.When.ONCE_PERSISTED)
        class Customer {
            Customer() {
            }
        }
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(ImmutableFacet.class);
        ImmutableAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        ImmutableAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof ImmutableFacetAnnotation));
        ImmutableFacetAnnotation immutableFacetAnnotation = (ImmutableFacetAnnotation)facet;
        ImmutableAnnotationFacetFactoryTest.assertEquals((Object)When.ONCE_PERSISTED, (Object)immutableFacetAnnotation.value());
        this.assertNoMethodsRemoved();
    }

    public void testImmutableAnnotationUntilPersistedPickedUpOnClass() {
        @Immutable(value=org.nakedobjects.applib.annotation.When.UNTIL_PERSISTED)
        class Customer {
            Customer() {
            }
        }
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(ImmutableFacet.class);
        ImmutableAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        ImmutableAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof ImmutableFacetAnnotation));
        ImmutableFacetAnnotation immutableFacetAnnotation = (ImmutableFacetAnnotation)facet;
        ImmutableAnnotationFacetFactoryTest.assertEquals((Object)When.UNTIL_PERSISTED, (Object)immutableFacetAnnotation.value());
        this.assertNoMethodsRemoved();
    }
}

