/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.object.validate;

import java.lang.reflect.Method;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.object.validate.ValidateObjectFacet;
import org.nakedobjects.metamodel.facets.object.validate.ValidateObjectFacetViaValidateMethod;
import org.nakedobjects.metamodel.facets.object.validate.ValidateObjectViaValidateMethodFacetFactory;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class ObjectValidMethodFacetFactoryTest
extends AbstractFacetFactoryTest {
    private ValidateObjectViaValidateMethodFacetFactory facetFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new ValidateObjectViaValidateMethodFacetFactory();
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        ObjectValidMethodFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        ObjectValidMethodFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        ObjectValidMethodFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        ObjectValidMethodFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        ObjectValidMethodFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testValidateMethodPickedUpAndMethodRemoved() {
        class Customer {
            Customer() {
            }

            public String validate() {
                return null;
            }
        }
        Method validateMethod = this.findMethod(Customer.class, "validate");
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(ValidateObjectFacet.class);
        ObjectValidMethodFacetFactoryTest.assertNotNull((Object)facet);
        ObjectValidMethodFacetFactoryTest.assertTrue((boolean)(facet instanceof ValidateObjectFacetViaValidateMethod));
        ObjectValidMethodFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(validateMethod));
    }
}

