/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.ordering.memberorder;

import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.ordering.OrderSet;
import org.nakedobjects.metamodel.facets.ordering.memberorder.DeweyOrderSet;
import org.nakedobjects.metamodel.facets.ordering.memberorder.MemberOrderFacetAnnotation;
import org.nakedobjects.metamodel.facets.ordering.memberorder.MemberPeerStub;
import org.nakedobjects.metamodel.specloader.internal.peer.NakedObjectMemberPeer;

public class DeweyOrderSetTest
extends TestCase {
    private final MemberPeerStub lastNameMember = new MemberPeerStub("LastName");
    private final MemberPeerStub firstNameMember = new MemberPeerStub("FirstName");
    private final MemberPeerStub houseNumberMember = new MemberPeerStub("HouseNumber");
    private final MemberPeerStub streetNameMember = new MemberPeerStub("StreetName");
    private final MemberPeerStub postalTownMember = new MemberPeerStub("PostalTown");
    private final NakedObjectMemberPeer[] lastNameAndFirstName = new MemberPeerStub[]{this.lastNameMember, this.firstNameMember};
    private final NakedObjectMemberPeer[] nameAndAddressMembers = new MemberPeerStub[]{this.lastNameMember, this.firstNameMember, this.houseNumberMember, this.streetNameMember, this.postalTownMember};
    private final NakedObjectMemberPeer[] lastNameFirstNameAndPostalTown = new MemberPeerStub[]{this.lastNameMember, this.firstNameMember, this.postalTownMember};

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(DeweyOrderSetTest.class));
    }

    protected void setUp() {
        LogManager.getLoggerRepository().setThreshold(Level.OFF);
    }

    protected void tearDown() throws Exception {
    }

    public void testDefaultGroup() {
        this.lastNameMember.addFacet((Facet)new MemberOrderFacetAnnotation("", "1", (FacetHolder)this.lastNameMember));
        this.firstNameMember.addFacet((Facet)new MemberOrderFacetAnnotation("", "2", (FacetHolder)this.firstNameMember));
        DeweyOrderSet orderSet = DeweyOrderSet.createOrderSet((NakedObjectMemberPeer[])this.lastNameAndFirstName);
        DeweyOrderSetTest.assertEquals((String)"", (String)orderSet.getGroupName());
        DeweyOrderSetTest.assertEquals((String)"", (String)orderSet.getGroupFullName());
        DeweyOrderSetTest.assertEquals((String)"", (String)orderSet.getGroupPath());
    }

    public void testDefaultGroupSize() {
        this.lastNameMember.addFacet((Facet)new MemberOrderFacetAnnotation("", "1", (FacetHolder)this.lastNameMember));
        this.firstNameMember.addFacet((Facet)new MemberOrderFacetAnnotation("", "2", (FacetHolder)this.firstNameMember));
        DeweyOrderSet orderSet = DeweyOrderSet.createOrderSet((NakedObjectMemberPeer[])this.lastNameAndFirstName);
        DeweyOrderSetTest.assertEquals((int)2, (int)orderSet.size());
        DeweyOrderSetTest.assertEquals((int)2, (int)orderSet.elementList().size());
        DeweyOrderSetTest.assertEquals((int)0, (int)orderSet.children().size());
    }

    public void testDefaultGroupTwoMembersSorted() {
        this.lastNameMember.addFacet((Facet)new MemberOrderFacetAnnotation("", "1", (FacetHolder)this.lastNameMember));
        this.firstNameMember.addFacet((Facet)new MemberOrderFacetAnnotation("", "2", (FacetHolder)this.firstNameMember));
        DeweyOrderSet orderSet = DeweyOrderSet.createOrderSet((NakedObjectMemberPeer[])this.lastNameAndFirstName);
        DeweyOrderSetTest.assertEquals((Object)((Object)this.lastNameMember), orderSet.elementList().get(0));
        DeweyOrderSetTest.assertEquals((Object)((Object)this.firstNameMember), orderSet.elementList().get(1));
    }

    public void testTwoMembersAtDefaultGroupOtherWay() {
        this.lastNameMember.addFacet((Facet)new MemberOrderFacetAnnotation("", "2", (FacetHolder)this.lastNameMember));
        this.firstNameMember.addFacet((Facet)new MemberOrderFacetAnnotation("", "1", (FacetHolder)this.firstNameMember));
        DeweyOrderSet orderSet = DeweyOrderSet.createOrderSet((NakedObjectMemberPeer[])this.lastNameAndFirstName);
        DeweyOrderSetTest.assertEquals((Object)((Object)this.firstNameMember), orderSet.elementList().get(0));
        DeweyOrderSetTest.assertEquals((Object)((Object)this.lastNameMember), orderSet.elementList().get(1));
    }

    public void testWithChildGroupDefaultGroupName() {
        this.lastNameMember.addFacet((Facet)new MemberOrderFacetAnnotation("", "1", (FacetHolder)this.lastNameMember));
        this.firstNameMember.addFacet((Facet)new MemberOrderFacetAnnotation("", "2", (FacetHolder)this.firstNameMember));
        this.houseNumberMember.addFacet((Facet)new MemberOrderFacetAnnotation("address", "1", (FacetHolder)this.houseNumberMember));
        this.streetNameMember.addFacet((Facet)new MemberOrderFacetAnnotation("address", "2", (FacetHolder)this.streetNameMember));
        this.postalTownMember.addFacet((Facet)new MemberOrderFacetAnnotation("address", "3", (FacetHolder)this.postalTownMember));
        DeweyOrderSet orderSet = DeweyOrderSet.createOrderSet((NakedObjectMemberPeer[])this.nameAndAddressMembers);
        DeweyOrderSetTest.assertEquals((String)"", (String)orderSet.getGroupName());
        DeweyOrderSetTest.assertEquals((String)"", (String)orderSet.getGroupFullName());
        DeweyOrderSetTest.assertEquals((String)"", (String)orderSet.getGroupPath());
    }

    public void testWithChildGroupSize() {
        this.lastNameMember.addFacet((Facet)new MemberOrderFacetAnnotation("", "1", (FacetHolder)this.lastNameMember));
        this.firstNameMember.addFacet((Facet)new MemberOrderFacetAnnotation("", "2", (FacetHolder)this.firstNameMember));
        this.houseNumberMember.addFacet((Facet)new MemberOrderFacetAnnotation("address", "1", (FacetHolder)this.houseNumberMember));
        this.streetNameMember.addFacet((Facet)new MemberOrderFacetAnnotation("address", "2", (FacetHolder)this.streetNameMember));
        this.postalTownMember.addFacet((Facet)new MemberOrderFacetAnnotation("address", "3", (FacetHolder)this.postalTownMember));
        DeweyOrderSet orderSet = DeweyOrderSet.createOrderSet((NakedObjectMemberPeer[])this.nameAndAddressMembers);
        DeweyOrderSetTest.assertEquals((int)1, (int)orderSet.children().size());
        DeweyOrderSetTest.assertEquals((int)3, (int)orderSet.size());
    }

    public void testWithChildGroupChildsGroupName() {
        this.lastNameMember.addFacet((Facet)new MemberOrderFacetAnnotation("", "1", (FacetHolder)this.lastNameMember));
        this.firstNameMember.addFacet((Facet)new MemberOrderFacetAnnotation("", "2", (FacetHolder)this.firstNameMember));
        this.houseNumberMember.addFacet((Facet)new MemberOrderFacetAnnotation("address", "1", (FacetHolder)this.houseNumberMember));
        this.streetNameMember.addFacet((Facet)new MemberOrderFacetAnnotation("address", "2", (FacetHolder)this.streetNameMember));
        this.postalTownMember.addFacet((Facet)new MemberOrderFacetAnnotation("address", "3", (FacetHolder)this.postalTownMember));
        DeweyOrderSet orderSet = DeweyOrderSet.createOrderSet((NakedObjectMemberPeer[])this.nameAndAddressMembers);
        List children = orderSet.children();
        OrderSet childOrderSet = (OrderSet)children.get(0);
        DeweyOrderSetTest.assertEquals((String)"Address", (String)childOrderSet.getGroupName());
        DeweyOrderSetTest.assertEquals((String)"address", (String)childOrderSet.getGroupFullName());
        DeweyOrderSetTest.assertEquals((String)"", (String)childOrderSet.getGroupPath());
    }

    public void testWithChildGroupChildsGroupSize() {
        this.lastNameMember.addFacet((Facet)new MemberOrderFacetAnnotation("", "1", (FacetHolder)this.lastNameMember));
        this.firstNameMember.addFacet((Facet)new MemberOrderFacetAnnotation("", "2", (FacetHolder)this.firstNameMember));
        this.houseNumberMember.addFacet((Facet)new MemberOrderFacetAnnotation("address", "1", (FacetHolder)this.houseNumberMember));
        this.streetNameMember.addFacet((Facet)new MemberOrderFacetAnnotation("address", "2", (FacetHolder)this.streetNameMember));
        this.postalTownMember.addFacet((Facet)new MemberOrderFacetAnnotation("address", "3", (FacetHolder)this.postalTownMember));
        DeweyOrderSet orderSet = DeweyOrderSet.createOrderSet((NakedObjectMemberPeer[])this.nameAndAddressMembers);
        OrderSet childOrderSet = (OrderSet)orderSet.children().get(0);
        DeweyOrderSetTest.assertEquals((int)3, (int)childOrderSet.size());
        DeweyOrderSetTest.assertEquals((int)0, (int)childOrderSet.children().size());
    }

    public void testWithChildGroupChildsGroupElementOrdering() {
        this.lastNameMember.addFacet((Facet)new MemberOrderFacetAnnotation("", "1", (FacetHolder)this.lastNameMember));
        this.firstNameMember.addFacet((Facet)new MemberOrderFacetAnnotation("", "2", (FacetHolder)this.firstNameMember));
        this.houseNumberMember.addFacet((Facet)new MemberOrderFacetAnnotation("address", "6", (FacetHolder)this.houseNumberMember));
        this.streetNameMember.addFacet((Facet)new MemberOrderFacetAnnotation("address", "5", (FacetHolder)this.streetNameMember));
        this.postalTownMember.addFacet((Facet)new MemberOrderFacetAnnotation("address", "4", (FacetHolder)this.postalTownMember));
        DeweyOrderSet orderSet = DeweyOrderSet.createOrderSet((NakedObjectMemberPeer[])this.nameAndAddressMembers);
        OrderSet childOrderSet = (OrderSet)orderSet.children().get(0);
        DeweyOrderSetTest.assertEquals((Object)((Object)this.postalTownMember), childOrderSet.elementList().get(0));
        DeweyOrderSetTest.assertEquals((Object)((Object)this.streetNameMember), childOrderSet.elementList().get(1));
        DeweyOrderSetTest.assertEquals((Object)((Object)this.houseNumberMember), childOrderSet.elementList().get(2));
    }

    public void testWithChildGroupOrderedAtEnd() {
        this.houseNumberMember.addFacet((Facet)new MemberOrderFacetAnnotation("address", "6", (FacetHolder)this.houseNumberMember));
        this.streetNameMember.addFacet((Facet)new MemberOrderFacetAnnotation("address", "5", (FacetHolder)this.streetNameMember));
        this.postalTownMember.addFacet((Facet)new MemberOrderFacetAnnotation("address", "4", (FacetHolder)this.postalTownMember));
        this.lastNameMember.addFacet((Facet)new MemberOrderFacetAnnotation("", "3", (FacetHolder)this.lastNameMember));
        this.firstNameMember.addFacet((Facet)new MemberOrderFacetAnnotation("", "2", (FacetHolder)this.firstNameMember));
        DeweyOrderSet orderSet = DeweyOrderSet.createOrderSet((NakedObjectMemberPeer[])this.nameAndAddressMembers);
        DeweyOrderSetTest.assertEquals((Object)((Object)this.firstNameMember), orderSet.elementList().get(0));
        DeweyOrderSetTest.assertEquals((Object)((Object)this.lastNameMember), orderSet.elementList().get(1));
        DeweyOrderSetTest.assertTrue((boolean)(orderSet.elementList().get(2) instanceof OrderSet));
    }

    public void testDefaultGroupNeitherAnnotatedSize() {
        DeweyOrderSet orderSet = DeweyOrderSet.createOrderSet((NakedObjectMemberPeer[])this.lastNameAndFirstName);
        DeweyOrderSetTest.assertEquals((int)2, (int)orderSet.elementList().size());
    }

    public void testDefaultGroupNeitherAnnotatedOrderedByName() {
        DeweyOrderSet orderSet = DeweyOrderSet.createOrderSet((NakedObjectMemberPeer[])this.lastNameAndFirstName);
        DeweyOrderSetTest.assertEquals((Object)((Object)this.firstNameMember), orderSet.elementList().get(0));
        DeweyOrderSetTest.assertEquals((Object)((Object)this.lastNameMember), orderSet.elementList().get(1));
    }

    public void testDefaultGroupMixOfAnnotatedAndNotSize() {
        this.lastNameMember.addFacet((Facet)new MemberOrderFacetAnnotation("", "1", (FacetHolder)this.lastNameMember));
        this.postalTownMember.addFacet((Facet)new MemberOrderFacetAnnotation("address", "2", (FacetHolder)this.postalTownMember));
        DeweyOrderSet orderSet = DeweyOrderSet.createOrderSet((NakedObjectMemberPeer[])this.lastNameFirstNameAndPostalTown);
        DeweyOrderSetTest.assertEquals((int)3, (int)orderSet.elementList().size());
    }

    public void testDefaultGroupMixOfAnnotatedAndNotOrderedWithAnnotatedFirst() {
        this.lastNameMember.addFacet((Facet)new MemberOrderFacetAnnotation("", "1", (FacetHolder)this.lastNameMember));
        this.postalTownMember.addFacet((Facet)new MemberOrderFacetAnnotation("", "2", (FacetHolder)this.postalTownMember));
        DeweyOrderSet orderSet = DeweyOrderSet.createOrderSet((NakedObjectMemberPeer[])this.lastNameFirstNameAndPostalTown);
        DeweyOrderSetTest.assertEquals((Object)((Object)this.lastNameMember), orderSet.elementList().get(0));
        DeweyOrderSetTest.assertEquals((Object)((Object)this.postalTownMember), orderSet.elementList().get(1));
        DeweyOrderSetTest.assertEquals((Object)((Object)this.firstNameMember), orderSet.elementList().get(2));
    }
}

