/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.ordering.memberorder;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.ordering.memberorder.MemberOrderComparator;
import org.nakedobjects.metamodel.facets.ordering.memberorder.MemberOrderFacetAnnotation;
import org.nakedobjects.metamodel.facets.ordering.memberorder.MemberPeerStub;
import org.nakedobjects.metamodel.specloader.internal.peer.NakedObjectMemberPeer;

public class MemberOrderComparatorTest
extends TestCase {
    private MemberOrderComparator comparator;
    private MemberOrderComparator laxComparator;
    private final MemberPeerStub m1 = new MemberPeerStub("abc");
    private final MemberPeerStub m2 = new MemberPeerStub("abc");

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(MemberOrderComparatorTest.class));
    }

    protected void setUp() {
        LogManager.getLoggerRepository().setThreshold(Level.OFF);
        this.comparator = new MemberOrderComparator(true);
        this.laxComparator = new MemberOrderComparator(false);
    }

    protected void tearDown() throws Exception {
    }

    public void testDefaultGroupOneComponent() {
        this.m1.addFacet((Facet)new MemberOrderFacetAnnotation("", "1", (FacetHolder)this.m1));
        this.m2.addFacet((Facet)new MemberOrderFacetAnnotation("", "2", (FacetHolder)this.m2));
        MemberOrderComparatorTest.assertEquals((int)-1, (int)this.comparator.compare((NakedObjectMemberPeer)this.m1, (NakedObjectMemberPeer)this.m2));
    }

    public void testDefaultGroupOneComponentOtherWay() {
        this.m1.addFacet((Facet)new MemberOrderFacetAnnotation("", "2", (FacetHolder)this.m1));
        this.m2.addFacet((Facet)new MemberOrderFacetAnnotation("", "1", (FacetHolder)this.m2));
        MemberOrderComparatorTest.assertEquals((int)1, (int)this.comparator.compare((NakedObjectMemberPeer)this.m1, (NakedObjectMemberPeer)this.m2));
    }

    public void testDefaultGroupOneComponentSame() {
        this.m1.addFacet((Facet)new MemberOrderFacetAnnotation("", "1", (FacetHolder)this.m1));
        this.m2.addFacet((Facet)new MemberOrderFacetAnnotation("", "1", (FacetHolder)this.m2));
        MemberOrderComparatorTest.assertEquals((int)0, (int)this.comparator.compare((NakedObjectMemberPeer)this.m1, (NakedObjectMemberPeer)this.m2));
    }

    public void testDefaultGroupOneSideRunsOutOfComponentsFirst() {
        this.m1.addFacet((Facet)new MemberOrderFacetAnnotation("", "1", (FacetHolder)this.m1));
        this.m2.addFacet((Facet)new MemberOrderFacetAnnotation("", "1.1", (FacetHolder)this.m2));
        MemberOrderComparatorTest.assertEquals((int)-1, (int)this.comparator.compare((NakedObjectMemberPeer)this.m1, (NakedObjectMemberPeer)this.m2));
    }

    public void testDefaultGroupOneSideRunsOutOfComponentsFirstOtherWay() {
        this.m1.addFacet((Facet)new MemberOrderFacetAnnotation("", "1.1", (FacetHolder)this.m1));
        this.m2.addFacet((Facet)new MemberOrderFacetAnnotation("", "1", (FacetHolder)this.m2));
        MemberOrderComparatorTest.assertEquals((int)1, (int)this.comparator.compare((NakedObjectMemberPeer)this.m1, (NakedObjectMemberPeer)this.m2));
    }

    public void testDefaultGroupOneSideRunsTwoComponents() {
        this.m1.addFacet((Facet)new MemberOrderFacetAnnotation("", "1.1", (FacetHolder)this.m1));
        this.m2.addFacet((Facet)new MemberOrderFacetAnnotation("", "1.2", (FacetHolder)this.m2));
        MemberOrderComparatorTest.assertEquals((int)-1, (int)this.comparator.compare((NakedObjectMemberPeer)this.m1, (NakedObjectMemberPeer)this.m2));
    }

    public void testDefaultGroupOneSideRunsTwoComponentsOtherWay() {
        this.m1.addFacet((Facet)new MemberOrderFacetAnnotation("", "1.2", (FacetHolder)this.m1));
        this.m2.addFacet((Facet)new MemberOrderFacetAnnotation("", "1.1", (FacetHolder)this.m2));
        MemberOrderComparatorTest.assertEquals((int)1, (int)this.comparator.compare((NakedObjectMemberPeer)this.m1, (NakedObjectMemberPeer)this.m2));
    }

    public void testDefaultGroupOneSideRunsLotsOfComponents() {
        this.m1.addFacet((Facet)new MemberOrderFacetAnnotation("", "1.2.5.8.3.3", (FacetHolder)this.m1));
        this.m2.addFacet((Facet)new MemberOrderFacetAnnotation("", "1.2.5.8.3.4", (FacetHolder)this.m2));
        MemberOrderComparatorTest.assertEquals((int)-1, (int)this.comparator.compare((NakedObjectMemberPeer)this.m1, (NakedObjectMemberPeer)this.m2));
    }

    public void testDefaultGroupOneSideRunsLotsOfComponentsOtherWay() {
        this.m1.addFacet((Facet)new MemberOrderFacetAnnotation("", "1.2.5.8.3.4", (FacetHolder)this.m1));
        this.m2.addFacet((Facet)new MemberOrderFacetAnnotation("", "1.2.5.8.3.3", (FacetHolder)this.m2));
        MemberOrderComparatorTest.assertEquals((int)1, (int)this.comparator.compare((NakedObjectMemberPeer)this.m1, (NakedObjectMemberPeer)this.m2));
    }

    public void testDefaultGroupOneSideRunsLotsOfComponentsSame() {
        this.m1.addFacet((Facet)new MemberOrderFacetAnnotation("", "1.2.5.8.3.3", (FacetHolder)this.m1));
        this.m2.addFacet((Facet)new MemberOrderFacetAnnotation("", "1.2.5.8.3.3", (FacetHolder)this.m2));
        MemberOrderComparatorTest.assertEquals((int)0, (int)this.comparator.compare((NakedObjectMemberPeer)this.m1, (NakedObjectMemberPeer)this.m2));
    }

    public void testNamedGroupOneSideRunsLotsOfComponents() {
        this.m1.addFacet((Facet)new MemberOrderFacetAnnotation("abc", "1.2.5.8.3.3", (FacetHolder)this.m1));
        this.m2.addFacet((Facet)new MemberOrderFacetAnnotation("abc", "1.2.5.8.3.4", (FacetHolder)this.m2));
        MemberOrderComparatorTest.assertEquals((int)-1, (int)this.comparator.compare((NakedObjectMemberPeer)this.m1, (NakedObjectMemberPeer)this.m2));
    }

    public void testEnsuresInSameGroup() {
        this.m1.addFacet((Facet)new MemberOrderFacetAnnotation("abc", "1", (FacetHolder)this.m1));
        this.m2.addFacet((Facet)new MemberOrderFacetAnnotation("def", "2", (FacetHolder)this.m2));
        try {
            MemberOrderComparatorTest.assertEquals((int)-1, (int)this.comparator.compare((NakedObjectMemberPeer)this.m1, (NakedObjectMemberPeer)this.m2));
            MemberOrderComparatorTest.fail((String)"Exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testEnsuresInSameGroupCanBeDisabled() {
        this.m1.addFacet((Facet)new MemberOrderFacetAnnotation("abc", "1", (FacetHolder)this.m1));
        this.m2.addFacet((Facet)new MemberOrderFacetAnnotation("def", "2", (FacetHolder)this.m2));
        MemberOrderComparatorTest.assertEquals((int)-1, (int)this.laxComparator.compare((NakedObjectMemberPeer)this.m1, (NakedObjectMemberPeer)this.m2));
    }

    public void testNonAnnotatedAfterAnnotated() {
        this.m2.addFacet((Facet)new MemberOrderFacetAnnotation("def", "2", (FacetHolder)this.m2));
        MemberOrderComparatorTest.assertEquals((int)1, (int)this.comparator.compare((NakedObjectMemberPeer)this.m1, (NakedObjectMemberPeer)this.m2));
    }
}

