/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.propparam.specification;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.nakedobjects.applib.spec.Specification;
import org.nakedobjects.applib.spec.SpecificationAnd;
import org.nakedobjects.metamodel.facets.propparam.specification.SpecificationAlwaysSatisfied;
import org.nakedobjects.metamodel.facets.propparam.specification.SpecificationNeverSatisfied;

public class SpecificationAndTests {
    private Specification alwaysSatisfied = new SpecificationAlwaysSatisfied();
    private Specification neverSatisfied = new SpecificationNeverSatisfied();

    @Test
    public void satisfiedIfNone() {
        class MySpecAnd
        extends SpecificationAnd {
            public MySpecAnd() {
                super(new Specification[0]);
            }
        }
        MySpecAnd mySpecAnd = new MySpecAnd();
        Assert.assertThat((Object)mySpecAnd.satisfies(null), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void satisfiedIfOneAndOkay() {
        class MySpecAnd
        extends SpecificationAnd {
            public MySpecAnd() {
                super(new Specification[]{SpecificationAndTests.this.alwaysSatisfied});
            }
        }
        MySpecAnd mySpecAnd = new MySpecAnd();
        Assert.assertThat((Object)mySpecAnd.satisfies(null), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void notSatisfiedIfOneAndNotOkay() {
        class MySpecAnd
        extends SpecificationAnd {
            public MySpecAnd() {
                super(new Specification[]{SpecificationAndTests.this.neverSatisfied});
            }
        }
        MySpecAnd mySpecAnd = new MySpecAnd();
        Assert.assertThat((Object)mySpecAnd.satisfies(null), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Assert.assertThat((Object)mySpecAnd.satisfies(null), (Matcher)CoreMatchers.is((Object)"not satisfied"));
    }

    @Test
    public void notSatisfiedIfTwoAndOneIsNotOkay() {
        class MySpecAnd
        extends SpecificationAnd {
            public MySpecAnd() {
                super(new Specification[]{SpecificationAndTests.this.alwaysSatisfied, SpecificationAndTests.this.neverSatisfied});
            }
        }
        MySpecAnd mySpecAnd = new MySpecAnd();
        Assert.assertThat((Object)mySpecAnd.satisfies(null), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Assert.assertThat((Object)mySpecAnd.satisfies(null), (Matcher)CoreMatchers.is((Object)"not satisfied"));
    }

    @Test
    public void satisfiedIfTwoAndBothAreOkay() {
        class MySpecAnd
        extends SpecificationAnd {
            public MySpecAnd() {
                super(new Specification[]{SpecificationAndTests.this.alwaysSatisfied, SpecificationAndTests.this.alwaysSatisfied});
            }
        }
        MySpecAnd mySpecAnd = new MySpecAnd();
        Assert.assertThat((Object)mySpecAnd.satisfies(null), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void notSatisfiedIfTwoAndBothAreNotOkayWithConcatenatedReason() {
        class MySpecAnd
        extends SpecificationAnd {
            public MySpecAnd() {
                super(new Specification[]{SpecificationAndTests.this.neverSatisfied, SpecificationAndTests.this.neverSatisfied});
            }
        }
        MySpecAnd mySpecAnd = new MySpecAnd();
        Assert.assertThat((Object)mySpecAnd.satisfies(null), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Assert.assertThat((Object)mySpecAnd.satisfies(null), (Matcher)CoreMatchers.is((Object)"not satisfied; not satisfied"));
    }
}

