/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.propparam.validate.mandatory;

import java.lang.reflect.Method;
import org.nakedobjects.applib.annotation.Optional;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.propparam.validate.mandatory.MandatoryFacet;
import org.nakedobjects.metamodel.facets.propparam.validate.mandatory.OptionalAnnotationFacetFactory;
import org.nakedobjects.metamodel.facets.propparam.validate.mandatory.OptionalFacetOverriddenByAnnotation;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class OptionalAnnotationFacetFactoryTest
extends AbstractFacetFactoryTest {
    private OptionalAnnotationFacetFactory facetFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new OptionalAnnotationFacetFactory();
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        OptionalAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        OptionalAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        OptionalAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        OptionalAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        OptionalAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testOptionalAnnotationPickedUpOnProperty() {
        class Customer {
            Customer() {
            }

            @Optional
            public String getFirstName() {
                return null;
            }
        }
        Method method = this.findMethod(Customer.class, "getFirstName");
        this.facetFactory.process(method, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(MandatoryFacet.class);
        OptionalAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        OptionalAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof OptionalFacetOverriddenByAnnotation));
    }

    public void testOptionalAnnotationPickedUpOnActionParameter() {
        class Customer {
            Customer() {
            }

            public void someAction(@Optional String foo) {
            }
        }
        Method method = this.findMethod(Customer.class, "someAction", new Class[]{String.class});
        this.facetFactory.processParams(method, 0, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(MandatoryFacet.class);
        OptionalAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        OptionalAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof OptionalFacetOverriddenByAnnotation));
    }

    public void testOptionalAnnotationIgnoredForPrimitiveOnProperty() {
        class Customer {
            Customer() {
            }

            @Optional
            public int getNumberOfOrders() {
                return 0;
            }
        }
        Method method = this.findMethod(Customer.class, "getNumberOfOrders");
        this.facetFactory.process(method, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        OptionalAnnotationFacetFactoryTest.assertNull((Object)this.facetHolder.getFacet(MandatoryFacet.class));
    }

    public void testOptionalAnnotationIgnoredForPrimitiveOnActionParameter() {
        class Customer {
            Customer() {
            }

            public void someAction(@Optional int foo) {
            }
        }
        Method method = this.findMethod(Customer.class, "someAction", new Class[]{Integer.TYPE});
        this.facetFactory.processParams(method, 0, (FacetHolder)this.facetHolder);
        OptionalAnnotationFacetFactoryTest.assertNull((Object)this.facetHolder.getFacet(MandatoryFacet.class));
    }
}

