/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.value;

import org.jmock.integration.junit4.JMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.metamodel.adapter.InvalidEntryException;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.FacetHolderImpl;
import org.nakedobjects.metamodel.value.CharValueSemanticsProviderAbstract;
import org.nakedobjects.metamodel.value.CharWrapperValueSemanticsProvider;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstract;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstractTestCase;

@RunWith(value=JMock.class)
public class CharacterValueSemanticsProviderTest
extends ValueSemanticsProviderAbstractTestCase {
    private CharValueSemanticsProviderAbstract value;
    private Character character;
    private NakedObject characterNO;
    private FacetHolder holder;

    @Before
    public void setUpObjects() throws Exception {
        this.character = new Character('r');
        this.characterNO = this.createAdapter(this.character);
        this.holder = new FacetHolderImpl();
        this.value = new CharWrapperValueSemanticsProvider(this.holder, this.mockConfiguration, this.mockSpecificationLoader, this.mockRuntimeContext);
        this.setValue((ValueSemanticsProviderAbstract)this.value);
    }

    @Test
    public void testParseLongString() throws Exception {
        try {
            this.value.parseTextEntry(null, "one");
            Assert.fail();
        }
        catch (InvalidEntryException invalidEntryException) {
            // empty catch block
        }
    }

    @Test
    public void testTitleOf() {
        Assert.assertEquals((Object)"r", (Object)this.value.displayTitleOf((Object)this.character));
    }

    @Test
    public void testValidParse() throws Exception {
        Object parse = this.value.parseTextEntry(null, "t");
        Assert.assertEquals((Object)new Character('t'), (Object)parse);
    }

    @Test
    public void testEncode() throws Exception {
        Assert.assertEquals((Object)"r", (Object)this.value.toEncodedString((Object)this.character));
    }

    @Test
    public void testDecode() throws Exception {
        Object restore = this.value.fromEncodedString("Y");
        Assert.assertEquals((Object)new Character('Y'), (Object)restore);
    }
}

