/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.value;

import org.jmock.Expectations;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.applib.value.Color;
import org.nakedobjects.metamodel.adapter.TextEntryParseException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.FacetHolderImpl;
import org.nakedobjects.metamodel.value.ColorValueSemanticsProvider;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstract;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstractTestCase;

@RunWith(value=JMock.class)
public class ColorValueSemanticsProviderTest
extends ValueSemanticsProviderAbstractTestCase {
    private ColorValueSemanticsProvider value;
    private Color color;
    private FacetHolder holder;

    @Before
    public void setUpObjects() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(ColorValueSemanticsProviderTest.this.mockConfiguration)).getString("nakedobjects.value.format.decimal");
                this.will(1.returnValue(null));
            }
        });
        this.color = new Color(0x3366FF);
        this.allowMockAdapterToReturn(this.color);
        this.holder = new FacetHolderImpl();
        this.value = new ColorValueSemanticsProvider(this.holder, this.mockConfiguration, this.mockSpecificationLoader, this.mockRuntimeContext);
        this.setValue((ValueSemanticsProviderAbstract)this.value);
    }

    @Test
    public void testParseValidString() throws Exception {
        Object newValue = this.value.parseTextEntry(null, "#3366fF");
        Assert.assertEquals((Object)this.color, (Object)newValue);
    }

    @Test
    public void testParseInvalidString() throws Exception {
        try {
            this.value.parseTextEntry(null, "red");
            Assert.fail();
        }
        catch (TextEntryParseException textEntryParseException) {
            // empty catch block
        }
    }

    @Test
    public void testTitleOf() {
        Assert.assertEquals((Object)"#3366FF", (Object)this.value.displayTitleOf((Object)this.color));
    }

    @Test
    public void testTitleOfBlack() {
        Assert.assertEquals((Object)"Black", (Object)this.value.displayTitleOf((Object)new Color(0)));
    }

    @Test
    public void testTitleOfWhite() {
        Assert.assertEquals((Object)"White", (Object)this.value.displayTitleOf((Object)new Color(0xFFFFFF)));
    }

    @Test
    public void testEncode() {
        Assert.assertEquals((Object)"3366ff", (Object)this.value.toEncodedString((Object)this.color));
    }

    @Test
    public void testDecode() throws Exception {
        Object newValue = this.value.fromEncodedString("3366ff");
        Assert.assertEquals((Object)this.color, (Object)newValue);
    }
}

