/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.value;

import org.jmock.Expectations;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.applib.value.DateTime;
import org.nakedobjects.applib.value.TestClock;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.FacetHolderImpl;
import org.nakedobjects.metamodel.value.DateTimeValueSemanticsProvider;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstract;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstractTestCase;

@RunWith(value=JMock.class)
public class DateTimeValueSemanticsProviderTest
extends ValueSemanticsProviderAbstractTestCase {
    private DateTimeValueSemanticsProvider adapter;
    private FacetHolder holder;

    @Before
    public void setUpObjects() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(DateTimeValueSemanticsProviderTest.this.mockConfiguration)).getString("nakedobjects.value.format.datetime");
                this.will(1.returnValue(null));
            }
        });
        TestClock.initialize();
        this.holder = new FacetHolderImpl();
        this.adapter = new DateTimeValueSemanticsProvider(this.holder, this.mockConfiguration, this.mockSpecificationLoader, this.mockRuntimeContext);
        this.setValue((ValueSemanticsProviderAbstract)this.adapter);
    }

    @Test
    public void testNow() {
        this.assertEntry("now", 2003, 8, 17, 21, 30, 25);
    }

    @Test
    public void testToday() {
        this.assertEntry("today", 2003, 8, 17, 21, 30, 25);
    }

    @Test
    public void testEntryWithShortFormat() {
        String entry = "21/5/07 10:30";
        int year = 2007;
        int month = 5;
        int day = 21;
        int hour = 10;
        int minute = 30;
        this.assertEntry("21/5/07 10:30", 2007, 5, 21, 10, 30, 0);
    }

    private void assertEntry(String entry, int year, int month, int day, int hour, int minute, int second) {
        Object object = this.adapter.parseTextEntry(null, entry);
        Assert.assertEquals((Object)new DateTime(year, month, day, hour, minute, second), (Object)object);
    }

    @Test
    public void testEntryWithMediumFormat() {
        this.assertEntry("21-May-2007 10:30", 2007, 5, 21, 10, 30, 0);
    }

    @Test
    public void testEntryWithShortISOFormat() {
        this.assertEntry("20070521T1030", 2007, 5, 21, 10, 30, 0);
    }

    @Test
    public void testEntryWithLongISOFormat() {
        this.assertEntry("2007-05-21 10:30", 2007, 5, 21, 10, 30, 0);
    }

    @Test
    public void testEmptyClears() {
        Assert.assertNull((Object)this.adapter.parseTextEntry(null, ""));
    }

    @Test
    public void testAddDayAndMonth() {
        this.assertEntry("+1d 1m", 2003, 9, 18, 21, 30, 25);
    }

    @Test
    public void testSubtractDayAndMonth() {
        this.assertEntry("-1d 1m", 2003, 7, 16, 21, 30, 25);
    }

    @Test
    public void testAddOneDay() {
        this.assertEntry("+1d", 2003, 8, 18, 21, 30, 25);
    }

    @Test
    public void testSubtractOneDay() {
        this.assertEntry("-1d", 2003, 8, 16, 21, 30, 25);
    }

    @Test
    public void testAddOneMonth() {
        this.assertEntry("+1m", 2003, 9, 17, 21, 30, 25);
    }

    @Test
    public void testAddOneYear() {
        this.assertEntry("+1y", 2004, 8, 17, 21, 30, 25);
    }

    @Test
    public void testAddOneHour() {
        this.assertEntry("+1H", 2003, 8, 17, 22, 30, 25);
    }

    @Test
    public void testAddOneMinute() {
        this.assertEntry("+1M", 2003, 8, 17, 21, 31, 25);
    }
}

