/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.value;

import org.jmock.Expectations;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.metamodel.adapter.TextEntryParseException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.FacetHolderImpl;
import org.nakedobjects.metamodel.value.FloatValueSemanticsProviderAbstract;
import org.nakedobjects.metamodel.value.FloatWrapperValueSemanticsProvider;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstract;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstractTestCase;

@RunWith(value=JMock.class)
public class FloatValueSemanticsProviderTest
extends ValueSemanticsProviderAbstractTestCase {
    private FloatValueSemanticsProviderAbstract value;
    private Float float1;
    private FacetHolder holder;

    @Before
    public void setUpObjects() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(FloatValueSemanticsProviderTest.this.mockConfiguration)).getString("nakedobjects.value.format.float");
                this.will(1.returnValue(null));
            }
        });
        this.float1 = new Float(32.5f);
        this.allowMockAdapterToReturn(this.float1);
        this.holder = new FacetHolderImpl();
        this.value = new FloatWrapperValueSemanticsProvider(this.holder, this.mockConfiguration, this.mockSpecificationLoader, this.mockRuntimeContext);
        this.setValue((ValueSemanticsProviderAbstract)this.value);
    }

    @Test
    public void testInvalidParse() throws Exception {
        try {
            this.value.parseTextEntry(null, "one");
            Assert.fail();
        }
        catch (TextEntryParseException textEntryParseException) {
            // empty catch block
        }
    }

    @Test
    public void testTitleOf() {
        Assert.assertEquals((Object)"32.5", (Object)this.value.displayTitleOf((Object)this.float1));
    }

    @Test
    public void testParse() throws Exception {
        Object parsed = this.value.parseTextEntry(null, "120.50");
        Assert.assertEquals((double)120.5, (double)((Float)parsed).floatValue(), (double)0.0);
    }

    @Test
    public void testParseBadlyFormatedEntry() throws Exception {
        Object parsed = this.value.parseTextEntry(null, "1,20.0");
        Assert.assertEquals((double)120.0, (double)((Float)parsed).floatValue(), (double)0.0);
    }

    @Test
    public void testEncode() throws Exception {
        Assert.assertEquals((Object)"32.5", (Object)this.getEncodeableFacet().toEncodedString(this.createAdapter(this.float1)));
    }

    @Test
    public void testDecode() throws Exception {
        Object restored = this.value.fromEncodedString("10.25");
        Assert.assertEquals((double)10.25, (double)((Float)restored).floatValue(), (double)0.0);
    }
}

