/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.value;

import java.sql.Time;
import java.util.Calendar;
import org.jmock.Expectations;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.applib.value.TestClock;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.FacetHolderImpl;
import org.nakedobjects.metamodel.value.JavaSqlTimeValueSemanticsProvider;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstract;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstractTestCase;

@RunWith(value=JMock.class)
public class JavaSqlTimeValueSemanticsProviderTest
extends ValueSemanticsProviderAbstractTestCase {
    private Time twoOClock;
    private NakedObject twoOClockNO;
    private JavaSqlTimeValueSemanticsProvider value;
    private FacetHolder holder;

    @Before
    public void setUpObjects() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(JavaSqlTimeValueSemanticsProviderTest.this.mockConfiguration)).getString("nakedobjects.value.format.time");
                this.will(1.returnValue(null));
            }
        });
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TestClock.timeZone);
        c.set(14, 0);
        c.set(1, 0);
        c.set(2, 0);
        c.set(5, 0);
        c.set(11, 14);
        c.set(12, 0);
        c.set(13, 0);
        this.twoOClock = new Time(c.getTimeInMillis());
        this.twoOClockNO = this.createAdapter(this.twoOClock);
        this.holder = new FacetHolderImpl();
        this.value = new JavaSqlTimeValueSemanticsProvider(this.holder, this.mockConfiguration, this.mockSpecificationLoader, this.mockRuntimeContext);
        this.setValue((ValueSemanticsProviderAbstract)this.value);
    }

    @Test
    public void testNewTime() {
        String asEncodedString = this.value.toEncodedString((Object)this.twoOClock);
        Assert.assertEquals((Object)"140000000", (Object)asEncodedString);
    }

    @Test
    public void testAdd() {
        Object newValue = this.value.add((Object)this.twoOClock, 0, 0, 0, 1, 15);
        Assert.assertEquals((Object)"15:15:00", (Object)newValue.toString());
    }

    @Test
    public void testAdd2() {
        Object newValue = this.value.add((Object)this.twoOClock, 0, 0, 0, 0, 0);
        Assert.assertEquals((Object)"14:00:00", (Object)newValue.toString());
    }
}

