/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.adapter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.nakedobjects.metamodel.adapter.ResolveException;

public final class ResolveState {
    private static final Hashtable<String, ResolveState> statesByName = new Hashtable();
    public static final ResolveState NEW = new ResolveState("New", "N~~~", null, ResolvableFrom.NOT_RESOLVABLE_FROM, ResolvableInto.NOT_RESOLVABLE_INTO, DeserializableFrom.NOT_DESERIALIZABLE_FROM, DeserializableInto.NOT_DESERIALIZABLE_INTO, RespondsToChanges.DOES_NOT_RESPOND_TO_CHANGES, RepresentsTransient.DOES_NOT_REPRESENT_TRANSIENT, RepresentsPersistent.DOES_NOT_REPRESENT_PERSISTENT, Resolving.DOES_NOT_REPRESENT_RESOLVING, Serializing.DOES_NOT_REPRESENT_SERIALIZING, ResolvePotential.WILL_NEVER_RESOLVE);
    public static final ResolveState TRANSIENT = new ResolveState("Transient", "T~~~", null, ResolvableFrom.NOT_RESOLVABLE_FROM, ResolvableInto.NOT_RESOLVABLE_INTO, DeserializableFrom.DESERIALIZABLE_FROM, DeserializableInto.NOT_DESERIALIZABLE_INTO, RespondsToChanges.DOES_NOT_RESPOND_TO_CHANGES, RepresentsTransient.REPRESENTS_TRANSIENT, RepresentsPersistent.DOES_NOT_REPRESENT_PERSISTENT, Resolving.DOES_NOT_REPRESENT_RESOLVING, Serializing.DOES_NOT_REPRESENT_SERIALIZING, ResolvePotential.WILL_NEVER_RESOLVE);
    public static final ResolveState GHOST = new ResolveState("Ghost", "PG~~", null, ResolvableFrom.RESOLVABLE_FROM, ResolvableInto.NOT_RESOLVABLE_INTO, DeserializableFrom.DESERIALIZABLE_FROM, DeserializableInto.NOT_DESERIALIZABLE_INTO, RespondsToChanges.RESPONDS_TO_CHANGES, RepresentsTransient.DOES_NOT_REPRESENT_TRANSIENT, RepresentsPersistent.REPRESENTS_PERSISTENT, Resolving.DOES_NOT_REPRESENT_RESOLVING, Serializing.DOES_NOT_REPRESENT_SERIALIZING, ResolvePotential.COULD_RESOLVE);
    public static final ResolveState PART_RESOLVED = new ResolveState("Part Resolved", "Pr~~", null, ResolvableFrom.RESOLVABLE_FROM, ResolvableInto.NOT_RESOLVABLE_INTO, DeserializableFrom.DESERIALIZABLE_FROM, DeserializableInto.NOT_DESERIALIZABLE_INTO, RespondsToChanges.RESPONDS_TO_CHANGES, RepresentsTransient.DOES_NOT_REPRESENT_TRANSIENT, RepresentsPersistent.REPRESENTS_PERSISTENT, Resolving.DOES_NOT_REPRESENT_RESOLVING, Serializing.DOES_NOT_REPRESENT_SERIALIZING, ResolvePotential.COULD_RESOLVE);
    public static final ResolveState RESOLVED = new ResolveState("Resolved", "PR~~", null, ResolvableFrom.RESOLVABLE_FROM, ResolvableInto.NOT_RESOLVABLE_INTO, DeserializableFrom.DESERIALIZABLE_FROM, DeserializableInto.NOT_DESERIALIZABLE_INTO, RespondsToChanges.RESPONDS_TO_CHANGES, RepresentsTransient.DOES_NOT_REPRESENT_TRANSIENT, RepresentsPersistent.REPRESENTS_PERSISTENT, Resolving.DOES_NOT_REPRESENT_RESOLVING, Serializing.DOES_NOT_REPRESENT_SERIALIZING, ResolvePotential.WILL_NEVER_RESOLVE);
    public static final ResolveState RESOLVING = new ResolveState("Resolving", "P~R~", RESOLVED, ResolvableFrom.NOT_RESOLVABLE_FROM, ResolvableInto.RESOLVABLE_INTO, DeserializableFrom.NOT_DESERIALIZABLE_FROM, DeserializableInto.DESERIALIZABLE_INTO, RespondsToChanges.DOES_NOT_RESPOND_TO_CHANGES, RepresentsTransient.DOES_NOT_REPRESENT_TRANSIENT, RepresentsPersistent.REPRESENTS_PERSISTENT, Resolving.REPRESENTS_RESOLVING, Serializing.DOES_NOT_REPRESENT_SERIALIZING, ResolvePotential.COULD_RESOLVE);
    public static final ResolveState RESOLVING_PART = new ResolveState("Resolving Part", "P~r~", PART_RESOLVED, ResolvableFrom.NOT_RESOLVABLE_FROM, ResolvableInto.RESOLVABLE_INTO, DeserializableFrom.NOT_DESERIALIZABLE_FROM, DeserializableInto.DESERIALIZABLE_INTO, RespondsToChanges.DOES_NOT_RESPOND_TO_CHANGES, RepresentsTransient.DOES_NOT_REPRESENT_TRANSIENT, RepresentsPersistent.REPRESENTS_PERSISTENT, Resolving.REPRESENTS_RESOLVING, Serializing.DOES_NOT_REPRESENT_SERIALIZING, ResolvePotential.COULD_RESOLVE);
    public static final ResolveState SERIALIZING_GHOST = new ResolveState("Serializing Ghost", "PG~S", GHOST, ResolvableFrom.NOT_RESOLVABLE_FROM, ResolvableInto.NOT_RESOLVABLE_INTO, DeserializableFrom.NOT_DESERIALIZABLE_FROM, DeserializableInto.NOT_DESERIALIZABLE_INTO, RespondsToChanges.DOES_NOT_RESPOND_TO_CHANGES, RepresentsTransient.DOES_NOT_REPRESENT_TRANSIENT, RepresentsPersistent.REPRESENTS_PERSISTENT, Resolving.DOES_NOT_REPRESENT_RESOLVING, Serializing.REPRESENTS_SERIALIZING, ResolvePotential.COULD_RESOLVE);
    public static final ResolveState SERIALIZING_PART_RESOLVED = new ResolveState("Serializing Part Resolved", "Pr~S", PART_RESOLVED, ResolvableFrom.NOT_RESOLVABLE_FROM, ResolvableInto.NOT_RESOLVABLE_INTO, DeserializableFrom.NOT_DESERIALIZABLE_FROM, DeserializableInto.NOT_DESERIALIZABLE_INTO, RespondsToChanges.DOES_NOT_RESPOND_TO_CHANGES, RepresentsTransient.DOES_NOT_REPRESENT_TRANSIENT, RepresentsPersistent.REPRESENTS_PERSISTENT, Resolving.DOES_NOT_REPRESENT_RESOLVING, Serializing.REPRESENTS_SERIALIZING, ResolvePotential.COULD_RESOLVE);
    public static final ResolveState SERIALIZING_RESOLVED = new ResolveState("Serializing Resolved", "PR~S", RESOLVED, ResolvableFrom.NOT_RESOLVABLE_FROM, ResolvableInto.NOT_RESOLVABLE_INTO, DeserializableFrom.NOT_DESERIALIZABLE_FROM, DeserializableInto.NOT_DESERIALIZABLE_INTO, RespondsToChanges.DOES_NOT_RESPOND_TO_CHANGES, RepresentsTransient.DOES_NOT_REPRESENT_TRANSIENT, RepresentsPersistent.REPRESENTS_PERSISTENT, Resolving.DOES_NOT_REPRESENT_RESOLVING, Serializing.REPRESENTS_SERIALIZING, ResolvePotential.WILL_NEVER_RESOLVE);
    public static final ResolveState SERIALIZING_TRANSIENT = new ResolveState("Serializing Transient", "T~~S", TRANSIENT, ResolvableFrom.NOT_RESOLVABLE_FROM, ResolvableInto.NOT_RESOLVABLE_INTO, DeserializableFrom.NOT_DESERIALIZABLE_FROM, DeserializableInto.DESERIALIZABLE_INTO, RespondsToChanges.DOES_NOT_RESPOND_TO_CHANGES, RepresentsTransient.REPRESENTS_TRANSIENT, RepresentsPersistent.DOES_NOT_REPRESENT_PERSISTENT, Resolving.DOES_NOT_REPRESENT_RESOLVING, Serializing.REPRESENTS_SERIALIZING, ResolvePotential.WILL_NEVER_RESOLVE);
    public static final ResolveState UPDATING = new ResolveState("Updating", "PU~~", RESOLVED, ResolvableFrom.NOT_RESOLVABLE_FROM, ResolvableInto.RESOLVABLE_INTO, DeserializableFrom.NOT_DESERIALIZABLE_FROM, DeserializableInto.DESERIALIZABLE_INTO, RespondsToChanges.DOES_NOT_RESPOND_TO_CHANGES, RepresentsTransient.DOES_NOT_REPRESENT_TRANSIENT, RepresentsPersistent.REPRESENTS_PERSISTENT, Resolving.DOES_NOT_REPRESENT_RESOLVING, Serializing.DOES_NOT_REPRESENT_SERIALIZING, ResolvePotential.COULD_RESOLVE);
    public static final ResolveState DESTROYED = new ResolveState("Destroyed", "D~~~", null, ResolvableFrom.NOT_RESOLVABLE_FROM, ResolvableInto.NOT_RESOLVABLE_INTO, DeserializableFrom.NOT_DESERIALIZABLE_FROM, DeserializableInto.NOT_DESERIALIZABLE_INTO, RespondsToChanges.RESPONDS_TO_CHANGES, RepresentsTransient.DOES_NOT_REPRESENT_TRANSIENT, RepresentsPersistent.DOES_NOT_REPRESENT_PERSISTENT, Resolving.DOES_NOT_REPRESENT_RESOLVING, Serializing.DOES_NOT_REPRESENT_SERIALIZING, ResolvePotential.WILL_NEVER_RESOLVE);
    public static final ResolveState VALUE = new ResolveState("Value", "V~~~", null, ResolvableFrom.NOT_RESOLVABLE_FROM, ResolvableInto.NOT_RESOLVABLE_INTO, DeserializableFrom.NOT_DESERIALIZABLE_FROM, DeserializableInto.NOT_DESERIALIZABLE_INTO, RespondsToChanges.RESPONDS_TO_CHANGES, RepresentsTransient.DOES_NOT_REPRESENT_TRANSIENT, RepresentsPersistent.DOES_NOT_REPRESENT_PERSISTENT, Resolving.DOES_NOT_REPRESENT_RESOLVING, Serializing.DOES_NOT_REPRESENT_SERIALIZING, ResolvePotential.WILL_NEVER_RESOLVE);
    public static Map<ResolveState, ResolveState[]> changeToStatesByState = new HashMap<ResolveState, ResolveState[]>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(GHOST, new ResolveState[]{DESTROYED, RESOLVING_PART, RESOLVING, UPDATING, SERIALIZING_GHOST});
            this.put(NEW, new ResolveState[]{TRANSIENT, GHOST, VALUE});
            this.put(TRANSIENT, new ResolveState[]{RESOLVED, SERIALIZING_TRANSIENT});
            this.put(PART_RESOLVED, new ResolveState[]{RESOLVING_PART, RESOLVING, SERIALIZING_PART_RESOLVED, UPDATING, DESTROYED});
            this.put(RESOLVED, new ResolveState[]{GHOST, SERIALIZING_RESOLVED, UPDATING, DESTROYED});
            this.put(RESOLVING, new ResolveState[]{RESOLVED});
            this.put(RESOLVING_PART, new ResolveState[]{PART_RESOLVED, RESOLVED});
            this.put(SERIALIZING_GHOST, new ResolveState[]{GHOST});
            this.put(SERIALIZING_PART_RESOLVED, new ResolveState[]{PART_RESOLVED});
            this.put(SERIALIZING_RESOLVED, new ResolveState[]{RESOLVED});
            this.put(SERIALIZING_TRANSIENT, new ResolveState[]{TRANSIENT});
            this.put(UPDATING, new ResolveState[]{RESOLVED});
            this.put(DESTROYED, new ResolveState[0]);
            this.put(VALUE, new ResolveState[0]);
        }
    };
    private final String code;
    private final ResolveState endState;
    private final String name;
    private final ResolvableFrom resolvableFrom;
    private final ResolvableInto resolvableInto;
    private final DeserializableFrom deserializableFrom;
    private final DeserializableInto deserializableInto;
    private final RespondsToChanges respondsToChanges;
    private final RepresentsTransient representsTransient;
    private final RepresentsPersistent representsPersistent;
    private final Resolving resolving;
    private final Serializing serializing;
    private final ResolvePotential resolvePotential;
    private HashSet<ResolveState> changeToStates;
    private transient String cachedToString;

    public static ResolveState getResolveState(String name) {
        return statesByName.get(name);
    }

    private ResolveState(String name, String code, ResolveState endState, ResolvableFrom resolvableFrom, ResolvableInto resolvableInto, DeserializableFrom deserializableFrom, DeserializableInto deserializableInto, RespondsToChanges respondsToChanges, RepresentsTransient representsTransient, RepresentsPersistent representsPersistent, Resolving resolving, Serializing serializing, ResolvePotential resolvePotential) {
        this.name = name;
        this.code = code;
        this.endState = endState;
        this.resolvableFrom = resolvableFrom;
        this.resolvableInto = resolvableInto;
        this.deserializableFrom = deserializableFrom;
        this.deserializableInto = deserializableInto;
        this.respondsToChanges = respondsToChanges;
        this.representsTransient = representsTransient;
        this.representsPersistent = representsPersistent;
        this.resolving = resolving;
        this.serializing = serializing;
        this.resolvePotential = resolvePotential;
        statesByName.put(name, this);
    }

    public String code() {
        return this.code;
    }

    public ResolveState getEndState() {
        return this.endState;
    }

    public boolean isPersistent() {
        return this.representsPersistent == RepresentsPersistent.REPRESENTS_PERSISTENT;
    }

    public boolean isTransient() {
        return this.representsTransient == RepresentsTransient.REPRESENTS_TRANSIENT;
    }

    public boolean canChangeTo(ResolveState newState) {
        if (newState.resolvableInto == ResolvableInto.NOT_RESOLVABLE_INTO) {
            throw new ResolveException("new state must be resolvable into");
        }
        if (this.resolvableFrom == ResolvableFrom.RESOLVABLE_FROM) {
            return this.isValidToChangeTo(newState);
        }
        return false;
    }

    @Deprecated
    public boolean isResolvable(ResolveState newState) {
        return this.canChangeTo(newState);
    }

    public boolean isDeserializable(ResolveState newState) {
        if (newState == null) {
            throw new ResolveException("new state must be specified");
        }
        if (newState.deserializableInto == DeserializableInto.NOT_DESERIALIZABLE_INTO) {
            throw new ResolveException("state must be deserializable into");
        }
        if (this.deserializableFrom == DeserializableFrom.DESERIALIZABLE_FROM) {
            return this.isValidToChangeTo(newState);
        }
        return false;
    }

    public boolean respondToChangesInPersistentObjects() {
        return this.respondsToChanges == RespondsToChanges.RESPONDS_TO_CHANGES;
    }

    public boolean isGhost() {
        return this == GHOST;
    }

    public boolean isValue() {
        return this == VALUE;
    }

    public boolean isNew() {
        return this == NEW;
    }

    public boolean isPartlyResolved() {
        return this == PART_RESOLVED;
    }

    public boolean isUpdating() {
        return this == UPDATING;
    }

    public boolean isDestroyed() {
        return this == DESTROYED;
    }

    public boolean isResolved() {
        return this == RESOLVED;
    }

    public boolean isResolving() {
        return this.resolving == Resolving.REPRESENTS_RESOLVING;
    }

    public boolean couldResolve() {
        return this.resolvePotential == ResolvePotential.COULD_RESOLVE;
    }

    public boolean isSerializing() {
        return this.serializing == Serializing.REPRESENTS_SERIALIZING;
    }

    public boolean isValidToChangeTo(ResolveState nextState) {
        this.cacheChangeToStatesIfNecessary();
        return this.changeToStates.contains(nextState);
    }

    private void cacheChangeToStatesIfNecessary() {
        if (this.changeToStates == null) {
            List<Object> nextStates = Arrays.asList((Object[])changeToStatesByState.get(this));
            this.changeToStates = new HashSet<Object>(nextStates);
        }
    }

    public String name() {
        return this.name;
    }

    public ResolveState serializeFrom() {
        if (this == RESOLVED) {
            return SERIALIZING_RESOLVED;
        }
        if (this == PART_RESOLVED) {
            return SERIALIZING_PART_RESOLVED;
        }
        if (this == GHOST) {
            return SERIALIZING_GHOST;
        }
        if (this == TRANSIENT) {
            return SERIALIZING_TRANSIENT;
        }
        return null;
    }

    public String toString() {
        if (this.cachedToString == null) {
            StringBuffer str = new StringBuffer();
            str.append("ResolveState [name=");
            str.append(this.name);
            str.append(",code=");
            str.append(this.code);
            if (this.endState != null) {
                str.append(",endstate=");
                str.append(this.endState.name());
            }
            str.append("]");
            this.cachedToString = str.toString();
        }
        return this.cachedToString;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ResolvePotential {
        COULD_RESOLVE,
        WILL_NEVER_RESOLVE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Serializing {
        REPRESENTS_SERIALIZING,
        DOES_NOT_REPRESENT_SERIALIZING;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Resolving {
        REPRESENTS_RESOLVING,
        DOES_NOT_REPRESENT_RESOLVING;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RepresentsPersistent {
        REPRESENTS_PERSISTENT,
        DOES_NOT_REPRESENT_PERSISTENT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RepresentsTransient {
        REPRESENTS_TRANSIENT,
        DOES_NOT_REPRESENT_TRANSIENT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RespondsToChanges {
        RESPONDS_TO_CHANGES,
        DOES_NOT_RESPOND_TO_CHANGES;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DeserializableInto {
        DESERIALIZABLE_INTO,
        NOT_DESERIALIZABLE_INTO;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DeserializableFrom {
        DESERIALIZABLE_FROM,
        NOT_DESERIALIZABLE_FROM;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ResolvableInto {
        RESOLVABLE_INTO,
        NOT_RESOLVABLE_INTO;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ResolvableFrom {
        RESOLVABLE_FROM,
        NOT_RESOLVABLE_FROM;

    }
}

