/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.commons.about;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.nakedobjects.metamodel.commons.about.ComponentDetails;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AboutNakedObjects {
    private static String applicationCopyrightNotice;
    private static String applicationName;
    private static String applicationVersion;
    private static String frameworkName;
    private static String frameworkVersion;
    private static String logo;
    private static String frameworkCopyright;
    private static String frameworkCompileDate;
    private static List<ComponentDetails> componentDetails;

    public static String findVersion() {
        try {
            String moduleId = "org.nakedobjects.plugins:dndviewer";
            String module = moduleId.replace(":", "/");
            InputStream resourceAsStream = AboutNakedObjects.class.getClassLoader().getResourceAsStream("META-INF/maven/" + module + "/pom.properties");
            if (resourceAsStream == null) {
                return "no version";
            }
            Properties p = new Properties();
            p.load(resourceAsStream);
            String version = p.getProperty("version");
            return version;
        }
        catch (IOException e) {
            throw new NakedObjectException(e);
        }
    }

    public static String getApplicationCopyrightNotice() {
        return applicationCopyrightNotice;
    }

    public static String getApplicationName() {
        return applicationName;
    }

    public static String getApplicationVersion() {
        return applicationVersion;
    }

    public static String getFrameworkCopyrightNotice() {
        return AboutNakedObjects.select(frameworkCopyright, "Copyright Naked Objects Group");
    }

    public static String getFrameworkCompileDate() {
        return frameworkCompileDate;
    }

    public static String getFrameworkName() {
        return AboutNakedObjects.select(frameworkName, "Naked Objects Framework");
    }

    public static String getImageName() {
        return AboutNakedObjects.select(logo, "splash-logo");
    }

    public static String getFrameworkVersion() {
        String version = "Version " + AboutNakedObjects.select(frameworkVersion, "unreleased");
        return version;
    }

    public static void main(String[] args) {
        System.out.println(AboutNakedObjects.getFrameworkName() + ", " + AboutNakedObjects.getFrameworkVersion());
        System.out.println(AboutNakedObjects.getFrameworkCopyrightNotice());
    }

    private static String select(String value, String defaultValue) {
        return value == null || value.startsWith("${") ? defaultValue : value;
    }

    public static void setApplicationCopyrightNotice(String applicationCopyrightNotice) {
        AboutNakedObjects.applicationCopyrightNotice = applicationCopyrightNotice;
    }

    public static void setApplicationName(String applicationName) {
        AboutNakedObjects.applicationName = applicationName;
    }

    public static void setApplicationVersion(String applicationVersion) {
        AboutNakedObjects.applicationVersion = applicationVersion;
    }

    public static void setComponentDetails(List<ComponentDetails> componentDetails) {
        AboutNakedObjects.componentDetails = componentDetails;
    }

    static {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("nof-version");
            logo = bundle.getString("framework.logo");
            frameworkVersion = bundle.getString("framework.version");
            frameworkName = bundle.getString("framework.name");
            frameworkCopyright = bundle.getString("framework.copyright");
            frameworkCompileDate = bundle.getString("framework.compile.date");
        }
        catch (MissingResourceException ex) {
            logo = "splash-logo";
            frameworkVersion = "${project.version}-r${buildNumber}";
            frameworkName = "${project.parent.name}";
            frameworkCopyright = "Copyright (c) 2002~2008 Naked Objects Group";
        }
    }
}

