/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.commons.encoding;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.metamodel.commons.encoding.Encodable;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;

public class ByteEncoderBuffer
implements ByteEncoder {
    static final String ENCODED_NULL_ARRAY = "null-array";
    static final String ENCODED_BOOLEAN_FALSE = "false";
    static final String ENCODED_BOOLEAN_TRUE = "true";
    static final String ENCODED_NULL_OBJECT = "null";
    private final OutputStream output;

    public ByteEncoderBuffer(OutputStream output) {
        this.output = output;
    }

    public void add(String entry) {
        byte[] value = entry.getBytes();
        if (value.length > 255) {
            throw new NakedObjectException("Value too long to be encoded: " + entry);
        }
        this.add(value);
    }

    public void add(byte[] value) {
        int len = value.length;
        if (len > 255) {
            throw new NakedObjectException("byte array too long to be encoded");
        }
        this.add((byte)len);
        try {
            this.output.write(value);
        }
        catch (IOException e) {
            throw new NakedObjectException(e);
        }
    }

    private void add(byte len) {
        try {
            this.output.write(len);
        }
        catch (IOException e) {
            throw new NakedObjectException(e);
        }
    }

    public void add(String[] list) {
        this.add((byte)list.length);
        for (int i = 0; i < list.length; ++i) {
            this.add(list[i]);
        }
    }

    public void add(long value) {
        this.add(Long.toString(value).getBytes());
    }

    public void add(int value) {
        this.add(Integer.toString(value).getBytes());
    }

    public void add(boolean flag) {
        this.add(flag ? (byte)1 : 0);
    }

    public void add(Object object) {
        if (object == null) {
            this.add(ENCODED_NULL_OBJECT);
            return;
        }
        if (object instanceof Boolean) {
            Boolean bool = (Boolean)object;
            this.add(bool != false ? ENCODED_BOOLEAN_TRUE : ENCODED_BOOLEAN_FALSE);
            return;
        }
        Class<?> clazz = object.getClass();
        String className = clazz.getName();
        this.addClassName(className);
        if (clazz.isArray()) {
            Object[] array = (Object[])object;
            int len = array.length;
            this.add(len);
            for (int i = 0; i < len; ++i) {
                this.add(array[i]);
            }
            return;
        }
        if (object instanceof Encodable) {
            Encodable encodable = (Encodable)object;
            encodable.encode(this);
            return;
        }
        if (object instanceof Serializable) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(object);
            }
            catch (IOException e) {
                throw new NakedObjectException("Object declared as Serializable but failed to write object: " + object, e);
            }
            byte[] bytes = baos.toByteArray();
            this.add(bytes);
            return;
        }
        throw new NakedObjectException("Object is not Encodable or Serializable: " + object);
    }

    private void addClassName(String className) {
        this.add(className);
    }

    public void add(Object[] objects) {
        if (objects == null) {
            this.add(ENCODED_NULL_ARRAY);
            return;
        }
        this.add(objects.getClass().getComponentType().getName());
        this.add(objects.length);
        for (int i = 0; i < objects.length; ++i) {
            this.add(objects[i]);
        }
    }

    public void end() {
        try {
            this.output.flush();
        }
        catch (IOException e) {
            throw new NakedObjectException(e);
        }
    }
}

