/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.commons.ensure;

import org.nakedobjects.metamodel.commons.ensure.NakedObjectAssertException;

public class Assert {
    public static void assertEquals(Object expected, Object actual) {
        Assert.assertEquals("", expected, actual);
    }

    public static void assertEquals(String message, int expected, int value) {
        if (expected != value) {
            throw new NakedObjectAssertException(message + " expected " + expected + "; but was " + value);
        }
    }

    public static void assertEquals(String message, Object expected, Object actual) {
        Assert.assertTrue(message + ": expected " + expected + " but was " + actual, expected == null && actual == null || expected != null && expected.equals(actual));
    }

    public static void assertFalse(boolean flag) {
        Assert.assertFalse("expected false", flag);
    }

    public static void assertFalse(String message, boolean flag) {
        Assert.assertTrue(message, !flag);
    }

    public static void assertFalse(String message, Object target, boolean flag) {
        Assert.assertTrue(message, target, !flag);
    }

    public static void assertNotNull(Object object) {
        Assert.assertNotNull("", object);
    }

    public static void assertNotNull(String message, Object object) {
        Assert.assertTrue("unexpected null: " + message, object != null);
    }

    public static void assertNotNull(String message, Object target, Object object) {
        Assert.assertTrue(message, target, object != null);
    }

    public static void assertNull(Object object) {
        Assert.assertTrue("unexpected reference; should be null", object == null);
    }

    public static void assertNull(String message, Object object) {
        Assert.assertTrue(message, object == null);
    }

    public static void assertSame(Object expected, Object actual) {
        Assert.assertSame("", expected, actual);
    }

    public static void assertSame(String message, Object expected, Object actual) {
        Assert.assertTrue(message + ": expected " + expected + " but was " + actual, expected == actual);
    }

    public static void assertTrue(boolean flag) {
        Assert.assertTrue("expected true", flag);
    }

    public static void assertTrue(String message, boolean flag) {
        Assert.assertTrue(message, null, flag);
    }

    public static void assertTrue(String message, Object target, boolean flag) {
        if (!flag) {
            throw new NakedObjectAssertException(message + (target == null ? "" : ": " + target));
        }
    }
}

