/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.commons.factory;

import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.commons.factory.InstanceCreationClassException;
import org.nakedobjects.metamodel.commons.factory.InstanceCreationException;
import org.nakedobjects.metamodel.commons.factory.UnavailableClassException;
import org.nakedobjects.metamodel.commons.lang.CastUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceFactory {
    public static Object createInstance(String className) {
        return InstanceFactory.createInstance(className, (Class)null, null);
    }

    public static Object createInstance(Class<?> cls) {
        return InstanceFactory.createInstance(cls, (Class)null, null);
    }

    public static <T> T createInstance(String className, Class<T> requiredClass) {
        return InstanceFactory.createInstance(className, (Class)null, requiredClass);
    }

    public static <T> T createInstance(Class<?> cls, Class<T> requiredClass) {
        return InstanceFactory.createInstance(cls, (Class)null, requiredClass);
    }

    public static <T> T createInstance(String className, String defaultTypeName, Class<T> requiredType) {
        Class defaultType = null;
        if (defaultTypeName != null) {
            try {
                defaultType = (Class)CastUtils.cast(Thread.currentThread().getContextClassLoader().loadClass(defaultTypeName));
                if (defaultType == null) {
                    throw new InstanceCreationClassException("Failed to load default type '" + defaultTypeName + "'");
                }
            }
            catch (ClassNotFoundException e) {
                throw new UnavailableClassException("The default type '" + defaultTypeName + "' cannot be found");
            }
            catch (NoClassDefFoundError e) {
                throw new InstanceCreationClassException("Default type '" + defaultTypeName + "' found, but is missing a dependent class: " + e.getMessage(), e);
            }
        }
        return InstanceFactory.createInstance(className, defaultType, requiredType);
    }

    public static <T> T createInstance(Class<?> cls, String defaultTypeName, Class<T> requiredType) {
        Class defaultType = null;
        if (defaultTypeName != null) {
            defaultType = InstanceFactory.loadClass(defaultTypeName, requiredType);
            try {
                defaultType = (Class)CastUtils.cast(Thread.currentThread().getContextClassLoader().loadClass(defaultTypeName));
                if (defaultType == null) {
                    throw new InstanceCreationClassException("Failed to load default type '" + defaultTypeName + "'");
                }
            }
            catch (ClassNotFoundException e) {
                throw new UnavailableClassException("The default type '" + defaultTypeName + "' cannot be found");
            }
            catch (NoClassDefFoundError e) {
                throw new InstanceCreationClassException("Default type '" + defaultTypeName + "' found, but is missing a dependent class: " + e.getMessage(), e);
            }
        }
        return InstanceFactory.createInstance(cls, defaultType, requiredType);
    }

    public static <T> T createInstance(String className, Class<? extends T> defaultType, Class<T> requiredType) {
        Assert.assertNotNull("Class to instantiate must be specified", className);
        Class<?> cls = null;
        try {
            cls = Thread.currentThread().getContextClassLoader().loadClass(className);
            if (cls == null) {
                throw new InstanceCreationClassException("Failed to load class '" + className + "'");
            }
            return InstanceFactory.createInstance(cls, defaultType, requiredType);
        }
        catch (ClassNotFoundException e) {
            if (className.indexOf(46) == -1) {
                throw new UnavailableClassException("The component '" + className + "' cannot be found");
            }
            throw new UnavailableClassException("The class '" + className + "' cannot be found");
        }
        catch (NoClassDefFoundError e) {
            throw new InstanceCreationClassException("Class '" + className + "' found , but is missing a dependent class: " + e.getMessage(), e);
        }
    }

    public static <T> T createInstance(Class<?> cls, Class<? extends T> defaultType, Class<T> requiredType) {
        Assert.assertNotNull("Class to instantiate must be specified", cls);
        try {
            if (requiredType == null || requiredType.isAssignableFrom(cls)) {
                Class tClass = (Class)CastUtils.cast(cls);
                return tClass.newInstance();
            }
            throw new InstanceCreationClassException("Class '" + cls.getName() + "' is not of type '" + requiredType + "'");
        }
        catch (NoClassDefFoundError e) {
            throw new InstanceCreationClassException("Class '" + cls + "'found , but is missing a dependent class: " + e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new InstanceCreationException("Could not instantiate an object of class '" + cls.getName() + "'; " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new InstanceCreationException("Could not access the class '" + cls.getName() + "'; " + e.getMessage());
        }
    }

    public static Class<?> loadClass(String className) {
        Assert.assertNotNull("Class to instantiate must be specified", className);
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new UnavailableClassException("The default type '" + className + "' cannot be found");
        }
        catch (NoClassDefFoundError e) {
            throw new InstanceCreationClassException("Default type '" + className + "' found, but is missing a dependent class: " + e.getMessage(), e);
        }
    }

    public static <R, T extends R> Class<T> loadClass(String className, Class<R> requiredType) {
        Assert.assertNotNull("Class to instantiate must be specified", className);
        try {
            Class<?> loadedClass = InstanceFactory.loadClass(className);
            if (requiredType != null && !requiredType.isAssignableFrom(loadedClass)) {
                throw new InstanceCreationClassException("Class '" + className + "' is not of type '" + requiredType + "'");
            }
            return (Class)CastUtils.cast(loadedClass);
        }
        catch (NoClassDefFoundError e) {
            throw new InstanceCreationClassException("Default type '" + className + "' found, but is missing a dependent class: " + e.getMessage(), e);
        }
    }
}

