/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.commons.logging;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.TriggeringEventEvaluator;
import org.nakedobjects.metamodel.commons.logging.SnapshotAppender;

public class SmtpSnapshotAppender
extends SnapshotAppender {
    private static final Logger LOG = Logger.getLogger(SmtpSnapshotAppender.class);
    private String server;
    private String recipient;
    private int port = 25;
    private String senderDomain = "domain";

    public SmtpSnapshotAppender(TriggeringEventEvaluator evaluator) {
        super(evaluator);
    }

    public SmtpSnapshotAppender() {
    }

    public void setServer(String mailServer) {
        if (mailServer == null) {
            throw new NullPointerException("mail server cannot be null");
        }
        this.server = mailServer;
    }

    public void setRecipient(String recipient) {
        if (recipient == null) {
            throw new NullPointerException("recipient cannot be null");
        }
        this.recipient = recipient;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setSenderDomain(String senderDomain) {
        if (senderDomain == null) {
            throw new NullPointerException("sender domain cannot be null");
        }
        this.senderDomain = senderDomain;
    }

    protected void writeSnapshot(String message, String details) {
        try {
            if (this.server == null) {
                throw new NullPointerException("mail server must be specified");
            }
            if (this.recipient == null) {
                throw new NullPointerException("recipient must be specified");
            }
            Socket s = new Socket(this.server, this.port);
            BufferedReader in = new BufferedReader(new InputStreamReader(s.getInputStream(), "8859_1"));
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(s.getOutputStream(), "8859_1"));
            this.send(in, out, "HELO " + this.senderDomain);
            this.send(in, out, "MAIL FROM: <no-reply@nakedobjects.org>");
            this.send(in, out, "RCPT TO: " + this.recipient);
            this.send(in, out, "DATA");
            this.send(out, "Subject: " + message);
            this.send(out, "From: Autosend");
            this.send(out, "Content-Type: " + this.layout.getContentType());
            this.send(out, "\r\n");
            this.send(out, details);
            this.send(out, "\r\n.\r\n");
            this.send(in, out, "QUIT");
            s.close();
        }
        catch (Exception e) {
            LOG.info((Object)"failed to send email with log", (Throwable)e);
        }
    }

    private void send(BufferedReader in, BufferedWriter out, String s) throws IOException {
        out.write(s + "\r\n");
        out.flush();
        in.readLine();
    }

    private void send(BufferedWriter out, String s) throws IOException {
        out.write(s + "\r\n");
        out.flush();
    }
}

