/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.commons.logging;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.commons.logging.SnapshotWriter;

public class SnapshotServer {
    private static final String SNAPSHOT_PROPERTIES = "snapshot.properties";
    private static final Logger LOG = Logger.getLogger(SnapshotServer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ServerSocket server;
        BasicConfigurator.configure();
        Properties prop = new Properties();
        FileInputStream propIn = null;
        try {
            propIn = new FileInputStream(SNAPSHOT_PROPERTIES);
            prop.load(propIn);
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)"failed to load properties file, snapshot.properties");
            return;
        }
        catch (IOException e) {
            LOG.error((Object)"failed to read properties file, snapshot.properties", (Throwable)e);
            return;
        }
        finally {
            if (propIn != null) {
                try {
                    propIn.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"failed to close properties file, snapshot.properties", (Throwable)e);
                    return;
                }
            }
        }
        String prefix = "nakedobjects.snapshot.";
        String portString = prop.getProperty("nakedobjects.snapshot.port", "9289");
        int port = Integer.valueOf(portString);
        String directoryPath = prop.getProperty("nakedobjects.snapshot.directory", ".");
        String fileName = prop.getProperty("nakedobjects.snapshot.filename", "log-snapshot-");
        String extension = prop.getProperty("nakedobjects.snapshot.extension", "txt");
        try {
            server = new ServerSocket(port);
        }
        catch (IOException e) {
            LOG.error((Object)"failed to start server", (Throwable)e);
            return;
        }
        while (true) {
            try {
                while (true) {
                    String line;
                    Socket s = server.accept();
                    LOG.info((Object)("receiving log from " + s.getInetAddress().getHostName()));
                    BufferedReader in = new BufferedReader(new InputStreamReader(s.getInputStream(), "8859_1"));
                    String message = in.readLine();
                    SnapshotWriter w = new SnapshotWriter(directoryPath, fileName, extension, message);
                    while ((line = in.readLine()) != null) {
                        w.appendLog(line);
                    }
                    s.close();
                    in.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)"failed to log", (Throwable)e);
                continue;
            }
            break;
        }
    }
}

