/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.commons.matchers;

import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.IsEqual;
import org.hamcrest.number.IsGreaterThan;
import org.hamcrest.text.StringContains;
import org.hamcrest.text.StringEndsWith;
import org.hamcrest.text.StringStartsWith;
import org.nakedobjects.metamodel.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NofMatchers {
    private NofMatchers() {
    }

    @Factory
    public static Matcher<String> containsStripNewLines(String expected) {
        final String strippedExpected = StringUtils.stripNewLines(expected);
        return new StringContains(strippedExpected){

            public boolean matchesSafely(String actual) {
                return super.matchesSafely(StringUtils.stripNewLines(actual));
            }

            public void describeTo(Description description) {
                description.appendText("a string (ignoring new lines) containing").appendValue((Object)strippedExpected);
            }
        };
    }

    @Factory
    public static Matcher<String> equalToStripNewLines(String expected) {
        final String strippedExpected = StringUtils.stripNewLines(expected);
        return new IsEqual<String>(strippedExpected){

            public boolean matches(Object actualObj) {
                String actual = (String)actualObj;
                return super.matches((Object)StringUtils.stripNewLines(actual));
            }

            public void describeTo(Description description) {
                description.appendText("a string (ignoring new lines) equal to").appendValue((Object)strippedExpected);
            }
        };
    }

    @Factory
    public static Matcher<String> startsWithStripNewLines(String expected) {
        final String strippedExpected = StringUtils.stripNewLines(expected);
        return new StringStartsWith(strippedExpected){

            public boolean matchesSafely(String actual) {
                return super.matchesSafely(StringUtils.stripNewLines(actual));
            }

            public void describeTo(Description description) {
                description.appendText("a string (ignoring new lines) starting with").appendValue((Object)strippedExpected);
            }
        };
    }

    @Factory
    public static Matcher<String> endsWithStripNewLines(String expected) {
        final String strippedExpected = StringUtils.stripNewLines(expected);
        return new StringEndsWith(strippedExpected){

            public boolean matchesSafely(String actual) {
                return super.matchesSafely(StringUtils.stripNewLines(actual));
            }

            public void describeTo(Description description) {
                description.appendText("a string (ignoring new lines) ending with").appendValue((Object)strippedExpected);
            }
        };
    }

    public static <T> Matcher<T> anInstanceOf(final Class<T> expected) {
        return new TypeSafeMatcher<T>(){

            public boolean matchesSafely(T actual) {
                return expected.isAssignableFrom(actual.getClass());
            }

            public void describeTo(Description description) {
                description.appendText("an instance of ").appendValue((Object)expected);
            }
        };
    }

    @Factory
    public static Matcher<String> nonEmptyString() {
        return new TypeSafeMatcher<String>(){

            public boolean matchesSafely(String str) {
                return str != null && str.length() > 0;
            }

            public void describeTo(Description description) {
                description.appendText("a non empty string");
            }
        };
    }

    @Factory
    public static Matcher<String> nonEmptyStringOrNull() {
        return CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.nullValue(String.class), NofMatchers.nonEmptyString()});
    }

    public static Matcher<List<?>> containsElementThat(final Matcher<?> elementMatcher) {
        return new TypeSafeMatcher<List<?>>(){

            public boolean matchesSafely(List<?> list) {
                for (Object o : list) {
                    if (!elementMatcher.matches(o)) continue;
                    return true;
                }
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("contains element that ").appendDescriptionOf((SelfDescribing)elementMatcher);
            }
        };
    }

    @Factory
    public static <T extends Comparable<T>> Matcher<T> greaterThan(T c) {
        return new IsGreaterThan(c);
    }

    @Factory
    public static Matcher<Class<?>> classEqualTo(Class<?> operand) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ClassEqualsMatcher
        extends TypeSafeMatcher<Class<?>> {
            private final Class<?> clazz;

            public ClassEqualsMatcher(Class<?> clazz) {
                this.clazz = clazz;
            }

            public boolean matchesSafely(Class<?> arg) {
                return this.clazz == arg;
            }

            public void describeTo(Description description) {
                description.appendValue(this.clazz);
            }
        }
        return new ClassEqualsMatcher(operand);
    }
}

