/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.config.loader;

import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.config.loader.ConfigurationLoader;
import org.nakedobjects.metamodel.config.loader.NotFoundPolicy;
import org.nakedobjects.metamodel.config.prop.PropertiesConfiguration;
import org.nakedobjects.metamodel.config.reader.propfile.PropertiesFileReader;

public class ConfigurationLoaderDefault
implements ConfigurationLoader {
    private static final Logger LOG = Logger.getLogger(ConfigurationLoaderDefault.class);
    private static final String DEFAULT_CONFIG_DIR = "config";
    private static final String DEFAULT_CONFIG_FILE = "nakedobjects.properties";
    protected static final String SHOW_EXPLORATION_OPTIONS = "nakedobjects.exploration.show";
    private boolean includeSystemProperties = false;
    private final Properties additionalProperties = new Properties();
    private final PropertiesConfiguration configuration;
    private final String defaultDirectory;

    public ConfigurationLoaderDefault() {
        this(null);
    }

    public ConfigurationLoaderDefault(String dir) {
        this.defaultDirectory = dir == null ? DEFAULT_CONFIG_DIR : dir;
        this.configuration = new PropertiesConfiguration();
        this.loadDefaultConfigurationFiles();
    }

    public NakedObjectConfiguration load() {
        if (this.configuration.getString(SHOW_EXPLORATION_OPTIONS) == null) {
            this.configuration.add(SHOW_EXPLORATION_OPTIONS, "yes");
        }
        if (this.includeSystemProperties) {
            this.configuration.add(System.getProperties());
        }
        this.configuration.add(this.additionalProperties);
        return this.configuration;
    }

    public void addConfigurationFile(String dir, String fileName, NotFoundPolicy notFoundPolicy) {
        try {
            PropertiesFileReader loader = new PropertiesFileReader(dir, fileName, notFoundPolicy);
            if (loader.isFound()) {
                this.configuration.add(loader.getProperties());
            } else {
                this.addConfigurationResource(fileName, notFoundPolicy);
            }
        }
        catch (Exception e) {
            this.addConfigurationResource(fileName, notFoundPolicy);
        }
    }

    private void addConfigurationResource(String fileName, NotFoundPolicy notFoundPolicy) {
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            Properties p = new Properties();
            URL url = cl.getResource(fileName);
            if (url == null) {
                throw new NakedObjectException("Failed to load configuration resource: " + fileName);
            }
            p.load(url.openStream());
            LOG.info((Object)("configuration resource " + fileName + " loaded"));
            this.configuration.add(p);
        }
        catch (Exception e) {
            if (notFoundPolicy == NotFoundPolicy.FAIL_FAST) {
                throw new NakedObjectException(e);
            }
            LOG.info((Object)("configuration resource " + fileName + " not found, but not needed"));
        }
    }

    public void addConfigurationFile(String fileName, NotFoundPolicy notFoundPolicy) {
        this.addConfigurationFile(this.defaultDirectory, fileName, notFoundPolicy);
    }

    public void loadDefaultConfigurationFiles() {
        this.addConfigurationFile(DEFAULT_CONFIG_FILE, NotFoundPolicy.FAIL_FAST);
    }

    public void setIncludeSystemProperties(boolean includeSystemProperties) {
        this.includeSystemProperties = includeSystemProperties;
    }

    public void add(String key, String value) {
        if (key != null && value != null) {
            this.additionalProperties.setProperty(key, value);
            LOG.info((Object)("added " + key + "=" + value));
        }
    }

    public void add(Properties properties) {
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.add(key, properties.getProperty(key));
        }
    }
}

