/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.config.prop;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.config.ConfigurationException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.config.NakedObjectConfigurationAware;
import org.nakedobjects.metamodel.config.reader.ConfigurationReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesConfiguration
implements NakedObjectConfiguration {
    private static final Logger LOG = Logger.getLogger(PropertiesConfiguration.class);
    private final String rootPath;
    private final Properties p = new Properties();

    public PropertiesConfiguration() {
        this(new File(".").getAbsolutePath(), "default root path: ");
    }

    public PropertiesConfiguration(String rootPath) {
        this(rootPath, "explicit root path: ");
    }

    private PropertiesConfiguration(String rootPath, String logMsg) {
        this.rootPath = rootPath;
        LOG.info((Object)(logMsg + rootPath));
    }

    public PropertiesConfiguration(ConfigurationReader loader) {
        this(loader.getProperties());
    }

    public PropertiesConfiguration(Properties properties) {
        this();
        this.add(properties);
    }

    public void add(Properties properties) {
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            this.p.put(name, properties.getProperty(name));
        }
    }

    @Override
    public void add(String key, String value) {
        if (key == null) {
            return;
        }
        if (this.p.containsKey(key)) {
            LOG.info((Object)("replacing " + key + "=" + this.p.get(key) + " with " + value));
        }
        this.p.put(key, value);
    }

    @Override
    public NakedObjectConfiguration createSubset(String prefix) {
        PropertiesConfiguration subset = new PropertiesConfiguration();
        String startsWith = prefix;
        if (!startsWith.endsWith(".")) {
            startsWith = startsWith + '.';
        }
        int prefixLength = startsWith.length();
        Enumeration<Object> e = this.p.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(startsWith)) continue;
            String modifiedKey = key.substring(prefixLength);
            subset.p.put(modifiedKey, this.p.get(key));
        }
        return subset;
    }

    @Override
    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) {
        String value = this.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        if ((value = value.toLowerCase()).equals("on") || value.equals("yes") || value.equals("true") || value.equals("")) {
            return true;
        }
        if (value.equals("off") || value.equals("no") || value.equals("false")) {
            return false;
        }
        throw new ConfigurationException("Illegal flag for name; must be one of on, off, yes, no, true or false");
    }

    @Override
    public Color getColor(String name) {
        return this.getColor(name, null);
    }

    @Override
    public Color getColor(String name, Color defaultValue) {
        String color = this.getProperty(name);
        if (color == null) {
            return defaultValue;
        }
        return Color.decode(color);
    }

    @Override
    public void debugData(DebugString str) {
        Enumeration<?> names = this.p.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            str.append(name, 55);
            str.append(" = ");
            str.appendln(this.p.getProperty(name));
        }
    }

    @Override
    public String debugTitle() {
        return "Properties Configuration";
    }

    @Override
    public Font getFont(String name) {
        return this.getFont(name, null);
    }

    @Override
    public Font getFont(String name, Font defaultValue) {
        String font = this.getProperty(name);
        if (font == null) {
            return defaultValue;
        }
        return Font.decode(font);
    }

    @Override
    public int getInteger(String name) {
        return this.getInteger(name, 0);
    }

    @Override
    public int getInteger(String name, int defaultValue) {
        String value = this.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        return Integer.valueOf(value);
    }

    @Override
    public String[] getList(String name) {
        String list = this.getString(name);
        if (list == null) {
            return new String[0];
        }
        StringTokenizer tokens = new StringTokenizer(list, ",");
        String[] array = new String[tokens.countTokens()];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            array[i++] = tokens.nextToken().trim();
        }
        return array;
    }

    @Override
    public NakedObjectConfiguration getProperties(String withPrefix) {
        int prefixLength = "".length();
        Properties pp = new Properties();
        Enumeration<Object> e = this.p.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(withPrefix)) continue;
            String modifiedKey = key.substring(prefixLength);
            pp.put(modifiedKey, this.p.get(key));
        }
        PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration();
        propertiesConfiguration.add(pp);
        return propertiesConfiguration;
    }

    private String getProperty(String name) {
        return this.getProperty(name, null);
    }

    private String getProperty(String name, String defaultValue) {
        String key = this.referedToAs(name);
        if (key.indexOf("..") >= 0) {
            throw new NakedObjectException("property names should not have '..' within them: " + name);
        }
        String property = this.p.getProperty(key, defaultValue);
        property = property != null ? property.trim() : null;
        LOG.debug((Object)("property: '" + key + "' =  '" + property + "'"));
        return property;
    }

    @Override
    public String rootPath() {
        return this.rootPath;
    }

    @Override
    public String getString(String name) {
        return this.getProperty(name);
    }

    @Override
    public String getString(String name, String defaultValue) {
        return this.getProperty(name, defaultValue);
    }

    @Override
    public boolean hasProperty(String name) {
        String key = this.referedToAs(name);
        return this.p.containsKey(key);
    }

    @Override
    public boolean isEmpty() {
        return this.p.isEmpty();
    }

    @Override
    public Enumeration<String> propertyNames() {
        final Enumeration<Object> keys = this.p.keys();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return keys.hasMoreElements();
            }

            @Override
            public String nextElement() {
                return (String)keys.nextElement();
            }
        };
    }

    private String referedToAs(String name) {
        return name;
    }

    @Override
    public int size() {
        return this.p.size();
    }

    public String toString() {
        return "ConfigurationParameters [properties=" + this.p + "]";
    }

    @Override
    public void injectInto(Object candidate) {
        if (NakedObjectConfigurationAware.class.isAssignableFrom(candidate.getClass())) {
            NakedObjectConfigurationAware cast = (NakedObjectConfigurationAware)NakedObjectConfigurationAware.class.cast(candidate);
            cast.setNakedObjectConfiguration(this);
        }
    }
}

