/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.consent;

import java.io.Serializable;
import org.hamcrest.CoreMatchers;
import org.nakedobjects.metamodel.commons.ensure.Ensure;
import org.nakedobjects.metamodel.commons.matchers.NofMatchers;
import org.nakedobjects.metamodel.consent.Allow;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.consent.InteractionResult;
import org.nakedobjects.metamodel.consent.Veto;

public abstract class ConsentAbstract
implements Serializable,
Consent {
    private static final long serialVersionUID = 1L;
    private final InteractionResult interactionResult;
    private final String reason;
    private String description;

    @Deprecated
    public static Consent allow(boolean allowed) {
        return allowed ? Allow.DEFAULT : Veto.DEFAULT;
    }

    @Deprecated
    public static Consent create(String reason) {
        if (reason != null) {
            return new Veto(reason);
        }
        return Allow.DEFAULT;
    }

    private static String determineReason(InteractionResult interactionResult) {
        if (interactionResult == null) {
            return null;
        }
        return interactionResult.getReason();
    }

    protected ConsentAbstract(InteractionResult interactionResult) {
        this(interactionResult, null, ConsentAbstract.determineReason(interactionResult));
    }

    protected ConsentAbstract(String description, String reason) {
        this(null, description, reason);
    }

    private ConsentAbstract(InteractionResult interactionResult, String description, String reason) {
        this.interactionResult = interactionResult;
        this.description = description;
        Ensure.ensureThatArg(reason, CoreMatchers.is(NofMatchers.nonEmptyStringOrNull()));
        this.reason = reason;
    }

    public String getReason() {
        return this.isVetoed() ? this.reason : null;
    }

    public Consent setDescription(String description) {
        this.description = description;
        return this;
    }

    public boolean isAllowed() {
        return this.reason == null || this.reason.equals("");
    }

    public boolean isVetoed() {
        return !this.isAllowed();
    }

    public InteractionResult getInteractionResult() {
        return this.interactionResult;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return (this.isVetoed() ? "VETOED" : "ALLOWED") + ", reason=" + this.reason;
    }
}

