/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.nakedobjects.metamodel.commons.filters.Filter;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MultiTypedFacet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FacetUtil {
    private FacetUtil() {
    }

    public static boolean addFacet(Facet facet) {
        if (facet == null) {
            return false;
        }
        facet.getFacetHolder().addFacet(facet);
        return true;
    }

    public static boolean addFacet(MultiTypedFacet facet) {
        if (facet == null) {
            return false;
        }
        facet.getFacetHolder().addFacet(facet);
        return true;
    }

    public static boolean addFacets(Facet[] facets) {
        boolean addedFacets = false;
        for (int i = 0; i < facets.length; ++i) {
            addedFacets = FacetUtil.addFacet(facets[i]) | addedFacets;
        }
        return addedFacets;
    }

    public static boolean addFacets(List<Facet> facetList) {
        boolean addedFacets = false;
        for (Facet facet : facetList) {
            addedFacets = FacetUtil.addFacet(facet) | addedFacets;
        }
        return addedFacets;
    }

    public static Class<? extends Facet>[] getFacetTypes(Map<Class<? extends Facet>, Facet> facetsByClass) {
        return facetsByClass.keySet().toArray(new Class[0]);
    }

    public static Facet[] getFacets(Map<Class<? extends Facet>, Facet> facetsByClass, Filter<Facet> filter) {
        ArrayList<Facet> filteredFacets = new ArrayList<Facet>();
        ArrayList<Facet> allFacets = new ArrayList<Facet>(facetsByClass.values());
        for (int i = 0; i < allFacets.size(); ++i) {
            Facet facet = (Facet)allFacets.get(i);
            if (!filter.accept(facet)) continue;
            filteredFacets.add(facet);
        }
        return filteredFacets.toArray(new Facet[0]);
    }

    public static Facet[] getFacets(Facet facet, Filter<Facet> filter) {
        if (filter.accept(facet)) {
            return new Facet[]{facet};
        }
        return new Facet[0];
    }

    public static void removeFacet(Map<Class<? extends Facet>, Facet> facetsByClass, Facet facet) {
        FacetUtil.removeFacet(facetsByClass, facet.facetType());
    }

    public static void removeFacet(Map<Class<? extends Facet>, Facet> facetsByClass, Class<? extends Facet> facetType) {
        Facet facet = facetsByClass.get(facetType);
        if (facet == null) {
            return;
        }
        facetsByClass.remove(facetType);
        facet.setFacetHolder(null);
    }

    public static void addFacet(Map<Class<? extends Facet>, Facet> facetsByClass, Facet facet) {
        facetsByClass.put(facet.facetType(), facet);
    }

    public static Facet[] toArray(List<Facet> facetList) {
        if (facetList == null) {
            return new Facet[0];
        }
        return facetList.toArray(new Facet[0]);
    }

    public static Hashtable<Class<? extends Facet>, Facet> getFacetsByType(FacetHolder nos) {
        Hashtable<Class<? extends Facet>, Facet> facetByType = new Hashtable<Class<? extends Facet>, Facet>();
        Class<? extends Facet>[] facetsFor = nos.getFacetTypes();
        for (int i = 0; i < facetsFor.length; ++i) {
            Class<? extends Facet> facetType = facetsFor[i];
            Facet facet = nos.getFacet(facetType);
            facetByType.put(facetType, facet);
        }
        return facetByType;
    }
}

