/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.actions.invoke;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.actcoll.typeof.TypeOfFacet;
import org.nakedobjects.metamodel.facets.actions.invoke.ActionInvocationFacetAbstract;
import org.nakedobjects.metamodel.java5.ImperativeFacet;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.specloader.ReflectiveActionException;
import org.nakedobjects.metamodel.util.InvokeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionInvocationFacetViaMethod
extends ActionInvocationFacetAbstract
implements ImperativeFacet {
    private static final Logger LOG = Logger.getLogger(ActionInvocationFacetViaMethod.class);
    private final Method method;
    private final int paramCount;
    private final NakedObjectSpecification onType;
    private final NakedObjectSpecification returnType;
    private final RuntimeContext runtimeContext;

    public ActionInvocationFacetViaMethod(Method method, NakedObjectSpecification onType, NakedObjectSpecification returnType, FacetHolder holder, RuntimeContext runtimeContext) {
        super(holder);
        this.method = method;
        this.paramCount = method.getParameterTypes().length;
        this.onType = onType;
        this.returnType = returnType;
        this.runtimeContext = runtimeContext;
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public NakedObjectSpecification getReturnType() {
        return this.returnType;
    }

    @Override
    public NakedObjectSpecification getOnType() {
        return this.onType;
    }

    @Override
    public NakedObject invoke(NakedObject inObject, NakedObject[] parameters) {
        if (parameters.length != this.paramCount) {
            LOG.error((Object)(this.method + " requires " + this.paramCount + " parameters, not " + parameters.length));
        }
        try {
            Object[] executionParameters = new Object[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                executionParameters[i] = ActionInvocationFacetViaMethod.unwrap(parameters[i]);
            }
            Object object = ActionInvocationFacetViaMethod.unwrap(inObject);
            Object result = this.method.invoke(object, executionParameters);
            LOG.debug((Object)(" action result " + result));
            if (result == null) {
                return null;
            }
            NakedObject adapter = this.getRuntimeContext().adapterFor(result);
            TypeOfFacet typeOfFacet = this.getFacetHolder().getFacet(TypeOfFacet.class);
            adapter.setTypeOfFacet(typeOfFacet);
            return adapter;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof IllegalStateException) {
                throw new ReflectiveActionException("IllegalStateException thrown while executing " + this.method + " " + e.getTargetException().getMessage(), e.getTargetException());
            }
            InvokeUtils.invocationException("Exception executing " + this.method, e);
            return null;
        }
        catch (IllegalAccessException e) {
            throw new ReflectiveActionException("Illegal access of " + this.method, e);
        }
    }

    private static Object unwrap(NakedObject adapter) {
        return adapter == null ? null : adapter.getObject();
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method;
    }

    private RuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }
}

