/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.collections;

import org.nakedobjects.metamodel.facets.FacetFactoryAbstract;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.actcoll.typeof.TypeOfFacet;
import org.nakedobjects.metamodel.facets.actcoll.typeof.TypeOfFacetDefaultToObject;
import org.nakedobjects.metamodel.facets.actcoll.typeof.TypeOfFacetInferredFromArray;
import org.nakedobjects.metamodel.facets.actcoll.typeof.TypeOfFacetInferredFromGenerics;
import org.nakedobjects.metamodel.facets.collections.JavaArrayFacet;
import org.nakedobjects.metamodel.facets.collections.JavaCollectionFacet;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContextAware;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;
import org.nakedobjects.metamodel.specloader.collectiontyperegistry.CollectionTypeRegistry;
import org.nakedobjects.metamodel.specloader.collectiontyperegistry.CollectionTypeRegistryAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionFacetFactory
extends FacetFactoryAbstract
implements CollectionTypeRegistryAware,
RuntimeContextAware {
    private CollectionTypeRegistry collectionTypeRegistry;
    private RuntimeContext runtimeContext;

    public CollectionFacetFactory() {
        super(NakedObjectFeatureType.OBJECTS_ONLY);
    }

    @Override
    public boolean process(Class<?> cls, MethodRemover methodRemover, FacetHolder holder) {
        if (this.collectionTypeRegistry.isCollectionType(cls)) {
            TypeOfFacet typeOfFacet = holder.getFacet(TypeOfFacet.class);
            if (typeOfFacet != null) {
                Class<?> collectionElementType = typeOfFacet.value();
            } else {
                Class<?> collectionElementType = this.collectionElementType(cls);
                holder.addFacet(collectionElementType != Object.class ? new TypeOfFacetInferredFromGenerics(collectionElementType, holder, this.getSpecificationLoader()) : new TypeOfFacetDefaultToObject(holder, this.getSpecificationLoader()));
            }
            holder.addFacet(new JavaCollectionFacet(holder, this.getRuntimeContext()));
            return true;
        }
        if (this.collectionTypeRegistry.isArrayType(cls)) {
            holder.addFacet(new JavaArrayFacet(holder, this.getRuntimeContext()));
            holder.addFacet(new TypeOfFacetInferredFromArray(cls.getComponentType(), holder, this.getSpecificationLoader()));
            return true;
        }
        return false;
    }

    private Class<?> collectionElementType(Class<?> cls) {
        return Object.class;
    }

    @Override
    public void setCollectionTypeRegistry(CollectionTypeRegistry collectionTypeRegistry) {
        this.collectionTypeRegistry = collectionTypeRegistry;
    }

    public RuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    @Override
    public void setRuntimeContext(RuntimeContext runtimeContext) {
        this.runtimeContext = runtimeContext;
    }
}

