/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.object.dirty;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.FacetUtil;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.object.dirty.ClearDirtyObjectFacetViaMethod;
import org.nakedobjects.metamodel.facets.object.dirty.IsDirtyObjectFacetViaMethod;
import org.nakedobjects.metamodel.facets.object.dirty.MarkDirtyObjectFacetViaMethod;
import org.nakedobjects.metamodel.java5.MethodPrefixBasedFacetFactoryAbstract;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirtyMethodsFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String MARK_DIRTY_PREFIX = "markDirty";
    private static final String CLEAR_DIRTY_PREFIX = "clearDirty";
    private static final String IS_DIRTY_PREFIX = "isDirty";
    private static final String[] PREFIXES = new String[]{"markDirty", "clearDirty", "isDirty"};

    public DirtyMethodsFacetFactory() {
        super(PREFIXES, NakedObjectFeatureType.OBJECTS_ONLY);
    }

    @Override
    public boolean process(Class<?> cls, MethodRemover methodRemover, FacetHolder facetHolder) {
        ArrayList<Facet> facets = new ArrayList<Facet>();
        Method method = this.findMethod(cls, false, IS_DIRTY_PREFIX, Boolean.TYPE, NO_PARAMETERS_TYPES);
        if (method != null) {
            methodRemover.removeMethod(method);
            facets.add(new IsDirtyObjectFacetViaMethod(method, facetHolder));
        }
        if ((method = this.findMethod(cls, false, CLEAR_DIRTY_PREFIX, Void.TYPE, NO_PARAMETERS_TYPES)) != null) {
            methodRemover.removeMethod(method);
            facets.add(new ClearDirtyObjectFacetViaMethod(method, facetHolder));
        }
        if ((method = this.findMethod(cls, false, MARK_DIRTY_PREFIX, Void.TYPE, NO_PARAMETERS_TYPES)) != null) {
            methodRemover.removeMethod(method);
            facets.add(new MarkDirtyObjectFacetViaMethod(method, facetHolder));
        }
        return FacetUtil.addFacets(facets);
    }
}

