/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.ordering;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import org.nakedobjects.metamodel.facets.ordering.memberorder.DeweyOrderSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderSet
implements Comparable {
    private final Vector<Object> elements = new Vector();
    private final String groupFullName;
    private final String groupName;
    private final String groupPath;
    private OrderSet parent;
    protected SortedSet<DeweyOrderSet> childOrderSets = new TreeSet<DeweyOrderSet>();

    public OrderSet(String groupFullName) {
        this.groupFullName = groupFullName;
        this.groupName = OrderSet.deriveGroupName(groupFullName);
        this.groupPath = OrderSet.deriveGroupPath(groupFullName);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getGroupFullName() {
        return this.groupFullName;
    }

    public String getGroupPath() {
        return this.groupPath;
    }

    private static String deriveGroupName(String groupFullName) {
        String groupSimpleName;
        StringTokenizer tokens = new StringTokenizer(groupFullName, ",", false);
        String[] groupNameComponents = new String[tokens.countTokens()];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            groupNameComponents[i] = tokens.nextToken();
            ++i;
        }
        String string = groupSimpleName = groupNameComponents.length > 0 ? groupNameComponents[groupNameComponents.length - 1] : "";
        if (groupSimpleName.length() > 1) {
            return groupSimpleName.substring(0, 1).toUpperCase() + groupSimpleName.substring(1);
        }
        return groupSimpleName.toUpperCase();
    }

    private static String deriveGroupPath(String groupFullName) {
        int lastComma = groupFullName.lastIndexOf(",");
        if (lastComma == -1) {
            return "";
        }
        return groupFullName.substring(0, lastComma);
    }

    protected void setParent(DeweyOrderSet parent) {
        this.parent = parent;
    }

    public OrderSet getParent() {
        return this.parent;
    }

    protected void addChild(DeweyOrderSet childOrderSet) {
        this.childOrderSets.add(childOrderSet);
    }

    public List<DeweyOrderSet> children() {
        ArrayList<DeweyOrderSet> list = new ArrayList<DeweyOrderSet>();
        list.addAll(this.childOrderSets);
        return list;
    }

    protected void copyOverChildren() {
        this.addAll(this.childOrderSets);
    }

    public List<Object> elementList() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(this.elements);
        return list;
    }

    public int size() {
        return this.elements.size();
    }

    protected void addElement(Object element) {
        this.elements.add(element);
    }

    public Enumeration<Object> elements() {
        return this.elements.elements();
    }

    protected void addAll(SortedSet<DeweyOrderSet> sortedMembers) {
        Iterator iter = sortedMembers.iterator();
        while (iter.hasNext()) {
            this.addElement(iter.next());
        }
    }

    public int compareTo(Object o) {
        return this.compareTo((OrderSet)o);
    }

    public int compareTo(OrderSet o) {
        return this.getGroupFullName().compareTo(o.getGroupFullName());
    }
}

