/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.ordering;

import java.util.StringTokenizer;
import org.nakedobjects.metamodel.commons.names.NameConvertorUtils;
import org.nakedobjects.metamodel.facets.ordering.OrderSet;
import org.nakedobjects.metamodel.specloader.internal.peer.NakedObjectMemberPeer;

public class SimpleOrderSet
extends OrderSet {
    private final SimpleOrderSet parent;
    private final NakedObjectMemberPeer[] members;

    public static SimpleOrderSet createOrderSet(String order, NakedObjectMemberPeer[] members) {
        SimpleOrderSet set = new SimpleOrderSet(members);
        StringTokenizer st = new StringTokenizer(order, ",");
        while (st.hasMoreTokens()) {
            String element = st.nextToken().trim();
            boolean ends = element.endsWith(")");
            if (ends) {
                element = element.substring(0, element.length() - 1).trim();
            }
            if (element.startsWith("(")) {
                int colon = element.indexOf(58);
                String groupName = element.substring(1, colon).trim();
                element = element.substring(colon + 1).trim();
                set = set.createSubOrderSet(groupName, element);
            } else {
                set.add(element);
            }
            if (!ends) continue;
            set = set.parent;
        }
        set.addAnyRemainingMember();
        return set;
    }

    private SimpleOrderSet(NakedObjectMemberPeer[] members) {
        super("");
        this.members = members;
        this.parent = null;
    }

    private SimpleOrderSet(SimpleOrderSet set, String groupName, String name, NakedObjectMemberPeer[] members) {
        super(groupName);
        this.parent = set;
        this.parent.addElement(this);
        this.members = members;
        this.add(name);
    }

    private void add(String name) {
        NakedObjectMemberPeer memberWithName = this.getMemberWithName(name);
        if (memberWithName != null) {
            this.addElement(memberWithName);
        }
    }

    private void addAnyRemainingMember() {
        for (int i = 0; i < this.members.length; ++i) {
            if (this.members[i] == null) continue;
            this.addElement(this.members[i]);
        }
    }

    private SimpleOrderSet createSubOrderSet(String groupName, String memberName) {
        return new SimpleOrderSet(this, groupName, memberName, this.members);
    }

    private NakedObjectMemberPeer getMemberWithName(String name) {
        String searchName = NameConvertorUtils.simpleName(name);
        for (int i = 0; i < this.members.length; ++i) {
            String testName;
            NakedObjectMemberPeer member = this.members[i];
            if (member == null || !(testName = NameConvertorUtils.simpleName(member.getIdentifier().getMemberName())).equals(searchName)) continue;
            this.members[i] = null;
            return member;
        }
        return null;
    }
}

