/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.ordering.memberorder;

import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.nakedobjects.metamodel.facets.ordering.OrderSet;
import org.nakedobjects.metamodel.facets.ordering.memberorder.MemberIdentifierComparator;
import org.nakedobjects.metamodel.facets.ordering.memberorder.MemberOrderComparator;
import org.nakedobjects.metamodel.facets.ordering.memberorder.MemberOrderFacet;
import org.nakedobjects.metamodel.specloader.internal.peer.NakedObjectMemberPeer;

public class DeweyOrderSet
extends OrderSet {
    public static DeweyOrderSet createOrderSet(NakedObjectMemberPeer[] members) {
        DeweyOrderSet deweyOrderSet;
        TreeMap sortedMembersByGroup = new TreeMap();
        TreeSet<NakedObjectMemberPeer> nonAnnotatedGroup = new TreeSet<NakedObjectMemberPeer>(new MemberIdentifierComparator());
        for (int i = 0; i < members.length; ++i) {
            NakedObjectMemberPeer member = members[i];
            MemberOrderFacet memberOrder = member.getFacet(MemberOrderFacet.class);
            if (memberOrder == null) {
                nonAnnotatedGroup.add(member);
                continue;
            }
            SortedSet sortedMembersForGroup = DeweyOrderSet.getSortedSet(sortedMembersByGroup, memberOrder.name());
            sortedMembersForGroup.add(member);
        }
        SortedSet defaultSet = DeweyOrderSet.getSortedSet(sortedMembersByGroup, "");
        defaultSet.addAll(nonAnnotatedGroup);
        Set groupNames = sortedMembersByGroup.keySet();
        TreeMap<String, DeweyOrderSet> orderSetsByGroup = new TreeMap<String, DeweyOrderSet>();
        for (String groupName : groupNames) {
            deweyOrderSet = new DeweyOrderSet(groupName);
            orderSetsByGroup.put(groupName, deweyOrderSet);
            DeweyOrderSet.ensureParentFor(orderSetsByGroup, deweyOrderSet);
        }
        for (String groupName : groupNames) {
            deweyOrderSet = (DeweyOrderSet)orderSetsByGroup.get(groupName);
            SortedSet sortedMembers = (SortedSet)sortedMembersByGroup.get(groupName);
            deweyOrderSet.addAll(sortedMembers);
            deweyOrderSet.copyOverChildren();
        }
        return (DeweyOrderSet)orderSetsByGroup.get("");
    }

    private static void ensureParentFor(SortedMap orderSetsByGroup, DeweyOrderSet deweyOrderSet) {
        String parentGroup = deweyOrderSet.getGroupPath();
        DeweyOrderSet parentOrderSet = (DeweyOrderSet)orderSetsByGroup.get(parentGroup);
        if (parentOrderSet == null) {
            parentOrderSet = new DeweyOrderSet(parentGroup);
            orderSetsByGroup.put(parentGroup, parentOrderSet);
            if (!parentGroup.equals("")) {
                DeweyOrderSet.ensureParentFor(orderSetsByGroup, deweyOrderSet);
            }
        }
        if (deweyOrderSet != parentOrderSet) {
            deweyOrderSet.setParent(parentOrderSet);
            parentOrderSet.addChild(deweyOrderSet);
        }
    }

    private static SortedSet getSortedSet(SortedMap sortedMembersByGroup, String groupName) {
        TreeSet sortedMembersForGroup = (TreeSet)sortedMembersByGroup.get(groupName);
        if (sortedMembersForGroup == null) {
            sortedMembersForGroup = new TreeSet(new MemberOrderComparator(true));
            sortedMembersByGroup.put(groupName, sortedMembersForGroup);
        }
        return sortedMembersForGroup;
    }

    private DeweyOrderSet(String groupName) {
        super(groupName);
    }

    public String toString() {
        return this.getGroupFullName() + ":" + this.size() + "el/" + (this.size() - this.childOrderSets.size()) + "m/" + this.childOrderSets.size() + "ch";
    }
}

