/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.properties;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.commons.names.NameUtils;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.FacetUtil;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.MethodScope;
import org.nakedobjects.metamodel.facets.actions.MandatoryFacetOverriddenByMethod;
import org.nakedobjects.metamodel.facets.disable.DisabledFacetAlways;
import org.nakedobjects.metamodel.facets.propcoll.access.PropertyAccessorFacetViaAccessor;
import org.nakedobjects.metamodel.facets.propcoll.derived.DerivedFacetInferred;
import org.nakedobjects.metamodel.facets.properties.choices.PropertyChoicesFacetViaMethod;
import org.nakedobjects.metamodel.facets.properties.defaults.PropertyDefaultFacetViaMethod;
import org.nakedobjects.metamodel.facets.properties.modify.PropertyClearFacetViaClearMethod;
import org.nakedobjects.metamodel.facets.properties.modify.PropertyClearFacetViaSetterMethod;
import org.nakedobjects.metamodel.facets.properties.modify.PropertyInitializationFacetViaSetterMethod;
import org.nakedobjects.metamodel.facets.properties.modify.PropertySetterFacetViaModifyMethod;
import org.nakedobjects.metamodel.facets.properties.modify.PropertySetterFacetViaSetterMethod;
import org.nakedobjects.metamodel.facets.properties.validate.PropertyValidateFacetViaMethod;
import org.nakedobjects.metamodel.java5.PropertyOrCollectionIdentifyingFacetFactoryAbstract;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContextAware;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;
import org.nakedobjects.metamodel.util.InvokeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyMethodsFacetFactory
extends PropertyOrCollectionIdentifyingFacetFactoryAbstract
implements RuntimeContextAware {
    private static final Logger LOG = Logger.getLogger(PropertyMethodsFacetFactory.class);
    protected static final String CLEAR_PREFIX = "clear";
    protected static final String GET_PREFIX = "get";
    protected static final String IS_PREFIX = "is";
    protected static final String MODIFY_PREFIX = "modify";
    protected static final String SET_PREFIX = "set";
    private static final String OPTIONAL_PREFIX = "optional";
    private static final String[] PREFIXES = new String[]{"clear", "is", "get", "modify", "set", "optional"};
    private RuntimeContext runtimeContext;

    public PropertyMethodsFacetFactory() {
        super(PREFIXES, NakedObjectFeatureType.PROPERTIES_ONLY);
    }

    @Override
    public boolean process(Method getMethod, MethodRemover methodRemover, FacetHolder property) {
        String capitalizedName = NameUtils.javaBaseName(getMethod.getName());
        Class<?> returnType = getMethod.getReturnType();
        Class[] paramTypes = new Class[]{returnType};
        Class<?> cls = getMethod.getDeclaringClass();
        ArrayList<Facet> facets = new ArrayList<Facet>();
        this.removeMethod(methodRemover, getMethod);
        facets.add(new PropertyAccessorFacetViaAccessor(getMethod, property));
        Method setMethod = this.findAndRemoveSetterMethod(facets, methodRemover, cls, capitalizedName, paramTypes, property);
        this.findAndRemoveModifyMethod(facets, methodRemover, cls, capitalizedName, paramTypes, property);
        Method clearMethod = this.findAndRemoveClearMethod(facets, methodRemover, cls, capitalizedName, paramTypes, property);
        this.ensureClearViaSetterIfRequired(facets, property, clearMethod, setMethod);
        this.findAndRemoveChoicesMethod(facets, methodRemover, cls, capitalizedName, returnType, property);
        this.findAndRemoveDefaultMethod(facets, methodRemover, cls, capitalizedName, returnType, property);
        this.findAndRemoveValidateMethod(facets, methodRemover, cls, paramTypes, capitalizedName, returnType, property);
        this.findAndRemoveNameMethod(facets, methodRemover, cls, capitalizedName, property);
        this.findAndRemoveDescriptionMethod(facets, methodRemover, cls, capitalizedName, property);
        this.findAndRemoveAlwaysHideMethod(facets, methodRemover, cls, capitalizedName, property);
        this.findAndRemoveProtectMethod(facets, methodRemover, cls, capitalizedName, property);
        this.findAndRemoveOptionalMethod(facets, methodRemover, cls, capitalizedName, returnType, property);
        this.findAndRemoveHideForSessionMethod(facets, methodRemover, cls, capitalizedName, paramTypes, property);
        this.findAndRemoveDisableForSessionMethod(facets, methodRemover, cls, capitalizedName, paramTypes, property);
        this.findAndRemoveHideMethod(facets, methodRemover, cls, false, capitalizedName, paramTypes, property);
        this.findAndRemoveHideMethod(facets, methodRemover, cls, false, capitalizedName, new Class[0], property);
        this.findAndRemoveDisableMethod(facets, methodRemover, cls, false, capitalizedName, paramTypes, property);
        this.findAndRemoveDisableMethod(facets, methodRemover, cls, false, capitalizedName, new Class[0], property);
        return FacetUtil.addFacets(facets);
    }

    private Method findAndRemoveSetterMethod(List<Facet> propertyFacets, MethodRemover methodRemover, Class<?> cls, String capitalizedName, Class<?>[] params, FacetHolder property) {
        Method method = this.findMethod(cls, false, SET_PREFIX + capitalizedName, Void.TYPE, params);
        this.removeMethod(methodRemover, method);
        if (method != null) {
            propertyFacets.add(new PropertySetterFacetViaSetterMethod(method, property));
            propertyFacets.add(new PropertyInitializationFacetViaSetterMethod(method, property));
        } else {
            propertyFacets.add(new DerivedFacetInferred(property));
            propertyFacets.add(new DisabledFacetAlways(property));
        }
        return method;
    }

    private Method findAndRemoveModifyMethod(List<Facet> propertyFacets, MethodRemover methodRemover, Class<?> cls, String capitalizedName, Class<?>[] params, FacetHolder property) {
        Method method = this.findMethod(cls, false, MODIFY_PREFIX + capitalizedName, Void.TYPE, params);
        this.removeMethod(methodRemover, method);
        if (method != null) {
            propertyFacets.add(new PropertySetterFacetViaModifyMethod(method, property));
        }
        return method;
    }

    private Method findAndRemoveClearMethod(List<Facet> propertyFacets, MethodRemover methodRemover, Class<?> cls, String capitalizedName, Class<?>[] params, FacetHolder property) {
        Method method = this.findMethod(cls, false, CLEAR_PREFIX + capitalizedName, Void.TYPE, NO_PARAMETERS_TYPES);
        this.removeMethod(methodRemover, method);
        if (method != null) {
            propertyFacets.add(new PropertyClearFacetViaClearMethod(method, property));
        }
        return method;
    }

    private void ensureClearViaSetterIfRequired(List<Facet> propertyFacets, FacetHolder property, Method clearMethod, Method setMethod) {
        if (setMethod != null && clearMethod == null) {
            propertyFacets.add(new PropertyClearFacetViaSetterMethod(setMethod, property));
        }
    }

    private void findAndRemoveOptionalMethod(List<Facet> propertyFacets, MethodRemover methodRemover, Class<?> cls, String name, Class<?> returnType, FacetHolder property) {
        boolean isOptional = false;
        Method method = this.findMethod(cls, true, OPTIONAL_PREFIX + name, Boolean.TYPE, NO_PARAMETERS_TYPES);
        this.removeMethod(methodRemover, method);
        if (method != null) {
            Boolean optionalMethodReturnValue = (Boolean)InvokeUtils.invoke(method, (Object)new Object[0]);
            isOptional = optionalMethodReturnValue | isOptional;
        }
        if (!isOptional) {
            return;
        }
        if (returnType.isPrimitive()) {
            LOG.warn((Object)(cls.getName() + "#" + name + " cannot be optional as it is a primitive; request ignored"));
            return;
        }
        propertyFacets.add(new MandatoryFacetOverriddenByMethod(property));
    }

    private void findAndRemoveValidateMethod(List<Facet> propertyFacets, MethodRemover methodRemover, Class<?> cls, Class<?>[] params, String capitalizedName, Class<?> returnType, FacetHolder property) {
        Method method = this.findMethod(cls, false, "validate" + capitalizedName, String.class, params);
        this.removeMethod(methodRemover, method);
        if (method == null) {
            return;
        }
        propertyFacets.add(new PropertyValidateFacetViaMethod(method, property));
    }

    private void findAndRemoveDefaultMethod(List<Facet> propertyFacets, MethodRemover methodRemover, Class<?> cls, String capitalizedName, Class<?> returnType, FacetHolder property) {
        Method method = this.findMethod(cls, false, "default" + capitalizedName, returnType, NO_PARAMETERS_TYPES);
        this.removeMethod(methodRemover, method);
        if (method == null) {
            return;
        }
        propertyFacets.add(new PropertyDefaultFacetViaMethod(method, property, this.getSpecificationLoader(), this.getRuntimeContext()));
    }

    private void findAndRemoveChoicesMethod(List<Facet> propertyFacets, MethodRemover methodRemover, Class<?> cls, String capitalizedName, Class<?> returnType, FacetHolder property) {
        Method method = this.findMethod(cls, false, "choices" + capitalizedName, null, NO_PARAMETERS_TYPES);
        methodRemover.removeMethod(method);
        if (method == null) {
            return;
        }
        propertyFacets.add(new PropertyChoicesFacetViaMethod(method, returnType, property, this.getSpecificationLoader(), this.getRuntimeContext()));
    }

    @Override
    public boolean isPropertyOrCollectionAccessorCandidate(Method method) {
        String methodName = method.getName();
        if (methodName.startsWith(GET_PREFIX)) {
            return true;
        }
        return methodName.startsWith(IS_PREFIX) && method.getReturnType() == Boolean.TYPE;
    }

    @Override
    public boolean isCollectionAccessor(Method method) {
        return false;
    }

    @Override
    public boolean isPropertyAccessor(Method method) {
        if (!this.isPropertyOrCollectionAccessorCandidate(method)) {
            return false;
        }
        Class<?> methodReturnType = method.getReturnType();
        return this.isCollectionOrArray(methodReturnType);
    }

    @Override
    public void findAndRemovePropertyAccessors(MethodRemover methodRemover, List<Method> methodListToAppendTo) {
        List<Method> isMethodList = methodRemover.removeMethods(MethodScope.OBJECT, IS_PREFIX, Boolean.TYPE, false, 0);
        methodListToAppendTo.addAll(isMethodList);
        List<Method> getMethodList = methodRemover.removeMethods(MethodScope.OBJECT, GET_PREFIX, Object.class, false, 0);
        methodListToAppendTo.addAll(getMethodList);
    }

    @Override
    public void findAndRemoveCollectionAccessors(MethodRemover methodRemover, List<Method> methodListToAppendTo) {
    }

    private RuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    @Override
    public void setRuntimeContext(RuntimeContext runtimeContext) {
        this.runtimeContext = runtimeContext;
    }
}

