/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.propparam.validate.mask;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.nakedobjects.applib.annotation.Mask;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.FacetUtil;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.object.ident.title.TitleFacet;
import org.nakedobjects.metamodel.facets.propparam.validate.mask.MaskFacet;
import org.nakedobjects.metamodel.facets.propparam.validate.mask.MaskFacetAnnotation;
import org.nakedobjects.metamodel.facets.propparam.validate.mask.TitleFacetBasedOnMask;
import org.nakedobjects.metamodel.java5.AnnotationBasedFacetFactoryAbstract;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaskAnnotationFacetFactory
extends AnnotationBasedFacetFactoryAbstract {
    public MaskAnnotationFacetFactory() {
        super(NakedObjectFeatureType.OBJECTS_PROPERTIES_AND_PARAMETERS);
    }

    @Override
    public boolean process(Class<?> cls, MethodRemover methodRemover, FacetHolder holder) {
        Mask annotation = this.getAnnotation(cls, Mask.class);
        return FacetUtil.addFacet(this.createMaskFacet(annotation, holder));
    }

    @Override
    public boolean process(Method method, MethodRemover methodRemover, FacetHolder holder) {
        if (method.getReturnType() == Void.TYPE) {
            return false;
        }
        Mask annotation = this.getAnnotation(method, Mask.class);
        return this.addMaskFacetAndCorrespondingTitleFacet(holder, annotation);
    }

    @Override
    public boolean processParams(Method method, int paramNum, FacetHolder holder) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (paramNum >= parameterTypes.length) {
            return false;
        }
        Annotation[] parameterAnnotations = this.getParameterAnnotations(method)[paramNum];
        for (int j = 0; j < parameterAnnotations.length; ++j) {
            if (!(parameterAnnotations[j] instanceof Mask)) continue;
            Mask annotation = (Mask)parameterAnnotations[j];
            return this.addMaskFacetAndCorrespondingTitleFacet(holder, annotation);
        }
        return false;
    }

    private MaskFacet createMaskFacet(Mask annotation, FacetHolder holder) {
        return annotation != null ? new MaskFacetAnnotation(annotation.value(), holder) : null;
    }

    private boolean addMaskFacetAndCorrespondingTitleFacet(FacetHolder holder, Mask annotation) {
        MaskFacet maskFacet = this.createMaskFacet(annotation, holder);
        if (maskFacet == null) {
            return false;
        }
        FacetUtil.addFacet(maskFacet);
        TitleFacet underlyingTitleFacet = holder.getFacet(TitleFacet.class);
        if (underlyingTitleFacet != null) {
            TitleFacetBasedOnMask titleFacet = new TitleFacetBasedOnMask(maskFacet, underlyingTitleFacet);
            FacetUtil.addFacet(titleFacet);
        }
        return true;
    }
}

